/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.kernel.config.file.manager;

import de.sillysky.nyssr.configuration.files.IConfigFileReader;
import de.sillysky.nyssr.impl.kernel.config.file.manager.CConfigFileManager;
import de.sillysky.nyssr.impl.kernel.config.file.manager.IDependencies;
import de.sillysky.nyssr.kernel.configuration.IKernelConfiguration;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.properties.string.INodeStringProperties;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.service.IServiceStarter;
import org.jetbrains.annotations.NotNull;

public class CPackageImplKernelConfigFile
implements IServiceStarter,
IDependencies {
    private static final String FILTER = "nid=SYSTEM";
    private IService mService;
    private INamespace mSystemNamespace;
    private INodeStringProperties mNodeStringProperties;
    private IConfigFileReader mConfigFileReader;
    private IKernelConfiguration mKernelConfiguration;

    @Override
    public void getDependencies(@NotNull IServiceDependencyList aDependencyList) {
        aDependencyList.add(INamespace.class, FILTER);
        aDependencyList.add(INodeStringProperties.class);
        aDependencyList.add(IConfigFileReader.class);
        aDependencyList.add(IKernelConfiguration.class);
    }

    @Override
    public void start(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService == null) {
            this.mSystemNamespace = aServiceRegistry.getServiceOrThrow(INamespace.class, FILTER);
            this.mNodeStringProperties = aServiceRegistry.getServiceOrThrow(INodeStringProperties.class);
            this.mConfigFileReader = aServiceRegistry.getServiceOrThrow(IConfigFileReader.class);
            this.mKernelConfiguration = aServiceRegistry.getServiceOrThrow(IKernelConfiguration.class);
            this.mService = new CConfigFileManager(this);
            this.mService.activate(aServiceRegistry);
        }
    }

    @Override
    public void stop(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        if (this.mService != null) {
            this.mService.deactivate(aServiceRegistry);
            this.mService = null;
        }
    }

    @Override
    @NotNull
    public INamespace getSystemNamespace() {
        return this.mSystemNamespace;
    }

    @Override
    @NotNull
    public INodeStringProperties getNodeStringProperties() {
        return this.mNodeStringProperties;
    }

    @Override
    @NotNull
    public IConfigFileReader getConfigFileReader() {
        return this.mConfigFileReader;
    }

    @Override
    @NotNull
    public IKernelConfiguration getKernelConfiguration() {
        return this.mKernelConfiguration;
    }
}

