/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.web.dialog.editconfigfiles;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.configuration.files.records.CRecordCreateConfigFile;
import de.sillysky.nyssr.configuration.files.records.CRecordDeleteConfigFile;
import de.sillysky.nyssr.configuration.files.records.CRecordGetConfigFileContent;
import de.sillysky.nyssr.configuration.files.records.CRecordGetConfigFileList;
import de.sillysky.nyssr.configuration.files.records.CRecordSetConfigFileContent;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.web.dialog.editconfigfiles.CConstants;
import de.sillysky.nyssr.json.CUtilJson;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.web.protocol.CAbstractWebDialog;
import de.sillysky.nyssr.remoteskin.web.protocol.records.CRecordWebNotifyClick1;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.properties.CStringProperties;
import de.sillysky.nyssr.util.resources.CUtilResources;
import de.sillysky.nyssr.util.string.CUtilBase64;
import java.nio.charset.Charset;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;

class C00403EditConfigFiles
extends CAbstractWebDialog {
    private static final IId MICRO_SERVICE_YES_NO = CIdFactory.fromObject((Object)"NY_WebDialogYesNo_00001");
    private static final IId MICRO_SERVICE_ENTER_TEXT = CIdFactory.fromObject((Object)"NY_WebDialogEnterText_00002");
    private final CNodeId mNodeId;
    private static final String ID_00403_MODAL = "id_00403_modal";
    private static final String ID_00403_DISMISS = "id_00403_dismiss";
    private static final String ID_00403_SAVE = "id_00403_save";
    private static final String ID_00403_DELETE = "id_00403_delete";
    private static final String ID_00403_NEW = "id_00403_new";
    private static final String ID_00403_SELECT = "id_00403_select";
    private static final String ID_00403_CONTENT = "id_00403_content";
    private static final String ID_00403_ALERT = "id_00403_alert";
    private static final String ID_00403_MY_MODALS = "id_00403_my_modals";
    private static final String ID_CSS = "id_00403_css";
    private static final String[] WIDGETS = new String[]{"id_00403_dismiss", "id_00403_save", "id_00403_delete"};
    private final List<Path> mFileList = new ArrayList<Path>();
    private String mCurrentPath;
    private boolean mDialogShown = false;

    public C00403EditConfigFiles(byte[] aSessionToken, @NotNull CTargetAddress aClientTargetAddress, @NotNull CTargetAddress aOwnerTargetAddress, @NotNull String aParentWidgetId, @NotNull CNodeId aNodeId) {
        super(aSessionToken, aClientTargetAddress, aOwnerTargetAddress, aParentWidgetId, CConstants.MICRO_SERVICE_ID);
        this.mNodeId = aNodeId;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordWebNotifyClick1.ID, this::asyncWebNotifyClick1);
        this.addMessageHandler(CRecordGetConfigFileList.ID, this::asyncGetConfigFileList);
        this.addMessageHandler(CRecordGetConfigFileContent.ID, this::asyncGetConfigFileContent);
        this.addMessageHandler(CRecordSetConfigFileContent.ID, this::asyncSetConfigFileContent);
        this.addMessageHandler(CRecordDeleteConfigFile.ID, this::asyncDeleteConfigFile);
        this.addMessageHandler(CRecordCreateConfigFile.ID, this::asyncCreateConfigFile);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String css = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00403.css");
        this.getWebApi().addCss(ID_CSS, css);
        this.sendGetListOfFiles();
        this.getWebApi().registerWidgets(WIDGETS);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncWebNotifyClick1(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        String path;
        if (aEnvelope.isAnswer()) {
            return false;
        }
        String id = CRecordWebNotifyClick1.getId((CRecord)aRecord, null);
        CStringProperties values = CRecordWebNotifyClick1.getValues((CRecord)aRecord, null);
        if (ID_00403_SELECT.equals(id)) {
            String path2;
            if (values != null && (path2 = values.get(ID_00403_SELECT, "")) != null && !path2.isEmpty()) {
                this.mCurrentPath = path2;
                this.sendGetContentOfFile(path2);
            }
        } else if (ID_00403_SAVE.equals(id)) {
            if (values != null) {
                String path3 = values.get(ID_00403_SELECT, "");
                String content = values.get(ID_00403_CONTENT, "");
                if (CUtilString.isValid((String)path3)) {
                    this.save(path3, content);
                }
            }
        } else if (ID_00403_DELETE.equals(id) && values != null && CUtilString.isValid((String)(path = values.get(ID_00403_SELECT, "")))) {
            this.askDelete(path);
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetConfigFileList(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            if (aEnvelope.getResult().isSuccess()) {
                String[] arr;
                this.mFileList.clear();
                for (String s : arr = CRecordGetConfigFileList.getList((CRecord)aRecord, null)) {
                    Path path = Paths.get(s, new String[0]);
                    this.mFileList.add(path);
                }
                if (!this.mDialogShown) {
                    this.showDialog();
                } else {
                    this.updateList();
                }
            }
            return true;
        }
        return false;
    }

    private boolean asyncGetConfigFileContent(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            String decoded;
            String encoded;
            if (aEnvelope.getResult().isSuccess() && (encoded = CRecordGetConfigFileContent.getContent((CRecord)aRecord, null)) != null && (decoded = CUtilBase64.decodeString((String)encoded)) != null) {
                decoded = decoded.replaceAll("\r", "");
                this.getWebApi().setValue(ID_00403_CONTENT, decoded);
            }
            return true;
        }
        return false;
    }

    private boolean asyncSetConfigFileContent(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.showResult(aEnvelope);
            return true;
        }
        return false;
    }

    private boolean asyncDeleteConfigFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.showResult(aEnvelope);
            if (aEnvelope.getResultCode() == 0) {
                this.sendGetListOfFiles();
            }
            return true;
        }
        return false;
    }

    private boolean asyncCreateConfigFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            this.showResult(aEnvelope);
            if (aEnvelope.getResultCode() == 0) {
                this.mCurrentPath = CRecordCreateConfigFile.getPath((CRecord)aRecord, null);
                this.sendGetListOfFiles();
            }
            return true;
        }
        return false;
    }

    private void showResult(@NotNull CEnvelope aEnvelope) throws CException {
        int code = aEnvelope.getResultCode();
        String message = aEnvelope.getResultText();
        message = code == 0 ? "Done." : message.replaceAll("\n", "<br>");
        this.showAlert(message);
    }

    public void notifyClick2(@NotNull String aWidgetId) throws CException {
        if (ID_00403_DISMISS.equals(aWidgetId)) {
            this.finish(2);
        } else if (ID_00403_NEW.equals(aWidgetId)) {
            this.enterFileName();
        }
    }

    private void showDialog() throws CException {
        String main = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00403_main.html");
        this.getWebApi().removeElement(ID_00403_MODAL);
        main = CUtilString.replaceAllOccurrences((String)main, (String)"{nodeid}", (String)this.mNodeId.toString());
        for (Path file : this.mFileList) {
            String sb = "<option value='" + file + "'>" + file.getFileName() + "</option>";
            main = CUtilString.insertBeforeFirstOccurrence((String)main, (String)"{row}", (String)sb);
        }
        main = CUtilString.replaceFirstOccurrence((String)main, (String)"{row}", (String)"");
        this.getWebApi().setInnerHtml(this.getParentWidgetId(), main);
        this.getWebApi().showModal(ID_00403_MODAL);
        this.getWebApi().addClickListener1(ID_00403_SELECT, new String[]{ID_00403_SELECT});
        this.getWebApi().addClickListener1(ID_00403_SAVE, new String[]{ID_00403_SELECT, ID_00403_CONTENT});
        this.getWebApi().addClickListener1(ID_00403_DELETE, new String[]{ID_00403_SELECT});
        this.getWebApi().addClickListener2(new String[]{ID_00403_DISMISS, ID_00403_NEW});
        this.mDialogShown = true;
    }

    private void updateList() throws CException {
        StringBuilder sb = new StringBuilder(1000);
        for (Path file : this.mFileList) {
            sb.append("<option value='").append(file).append("'>").append(file.getFileName()).append("</option>\n");
        }
        this.getWebApi().setInnerHtml(ID_00403_SELECT, sb.toString());
        this.getWebApi().setValue(ID_00403_CONTENT, "");
        if (this.mCurrentPath != null) {
            this.getWebApi().setValue(ID_00403_SELECT, this.mCurrentPath);
            this.sendGetContentOfFile(this.mCurrentPath);
        }
    }

    private void sendGetListOfFiles() throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)this.mNodeId);
        CRecord record = CRecordGetConfigFileList.create();
        this.sendRequest(env, record);
    }

    private void sendGetContentOfFile(@NotNull String aPath) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)this.mNodeId);
        env.setSessionToken(this.getSessionToken());
        CRecord record = CRecordGetConfigFileContent.create();
        CRecordGetConfigFileContent.setPath((CRecord)record, (String)aPath);
        this.sendRequest(env, record);
    }

    private void save(@NotNull String aPath, @NotNull String aContent) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)this.mNodeId);
        env.setSessionToken(this.getSessionToken());
        CRecord record = CRecordSetConfigFileContent.create();
        CRecordSetConfigFileContent.setPath((CRecord)record, (String)aPath);
        String encoded = CUtilBase64.encodeToStringWithPrefix((String)aContent);
        CRecordSetConfigFileContent.setContent((CRecord)record, (String)encoded);
        this.sendRequest(env, record);
    }

    private void askDelete(@NotNull String aPath) throws CException {
        Path path = Paths.get(aPath, new String[0]);
        CStringProperties sp = new CStringProperties();
        sp.put("message", "Do you want to delete the file " + path.getFileName() + "?");
        sp.put("action", "delete");
        sp.put("path", aPath);
        this.getWebDialogApi().showWebDialog(MICRO_SERVICE_YES_NO, this.getSessionToken(), ID_00403_MY_MODALS, sp);
    }

    private void enterFileName() throws CException {
        CStringProperties sp = new CStringProperties();
        sp.put("message", "Enter a new configuration file name.");
        sp.put("pattern", "[A-Za-z0-9_-]+");
        sp.put("placeholder", "filename");
        sp.put("aria-label", "Name of the new configuration file");
        this.getWebDialogApi().showWebDialog(MICRO_SERVICE_ENTER_TEXT, this.getSessionToken(), ID_00403_MY_MODALS, sp);
    }

    private void delete(@NotNull String aPath) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)this.mNodeId);
        env.setSessionToken(this.getSessionToken());
        CRecord record = CRecordDeleteConfigFile.create();
        CRecordDeleteConfigFile.setPath((CRecord)record, (String)aPath);
        this.sendRequest(env, record);
    }

    public void notifySubDialogFinished(@NotNull IId aMicroServiceId, @NotNull CStringProperties aResults) throws CException {
        String fileName;
        if (MICRO_SERVICE_YES_NO.equals((Object)aMicroServiceId)) {
            String action = aResults.get("action");
            String result = aResults.get("result");
            if ("delete".equals(action) && "yes".equals(result)) {
                String path = aResults.get("path");
                this.delete(path);
            }
        } else if (MICRO_SERVICE_ENTER_TEXT.equals((Object)aMicroServiceId) && CUtilString.isValid((String)(fileName = aResults.get("result")))) {
            if (!fileName.endsWith(".cfg")) {
                fileName = fileName.concat(".cfg");
            }
            if (this.hasFilename(fileName)) {
                this.showAlert("The file " + fileName + " already exists.");
            } else {
                this.createNewFile(fileName);
            }
        }
    }

    private void createNewFile(@NotNull String aFileName) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)this.mNodeId);
        env.setSessionToken(this.getSessionToken());
        CRecord record = CRecordCreateConfigFile.create();
        CRecordCreateConfigFile.setFilename((CRecord)record, (String)aFileName);
        String def = CUtilResources.readTextFile(((Object)((Object)this)).getClass(), (String)"/config.cfg", (Charset)StandardCharsets.UTF_8);
        String encoded = CUtilBase64.encodeToStringWithPrefix((String)def);
        CRecordCreateConfigFile.setContent((CRecord)record, (String)encoded);
        this.sendRequest(env, record);
    }

    protected void clearBeforeDismiss() throws CException {
        this.getWebApi().removeCss(ID_CSS);
        this.getWebApi().removeElement(ID_00403_MODAL);
    }

    private boolean hasFilename(@NotNull String aFilename) {
        return this.mFileList.stream().map(path -> path.getFileName().toString()).anyMatch(fileName -> fileName.equals(aFilename));
    }

    private void showAlert(@NotNull String aMessage) throws CException {
        String alert = CUtilJson.loadJson(((Object)((Object)this)).getClass(), (String)"/html/00403_alert.html");
        alert = CUtilString.replaceFirstOccurrence((String)alert, (String)"{message}", (String)aMessage);
        this.getWebApi().setInnerHtml(ID_00403_ALERT, alert);
    }
}

