/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CSwingNode;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CSwingTree;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.tree.CTreeNode;
import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JTree;
import javax.swing.border.Border;
import javax.swing.tree.DefaultTreeCellRenderer;

public class CNodeRenderer
extends DefaultTreeCellRenderer {
    private final CSwingTree mWidget;
    private final JLabel mLabel = new JLabel();
    private final Color mDefaultBackgroundNonSelectionColor;
    private final Color mDefaultBackgroundSelectionColor;
    private final Font mDefaultFont;

    public CNodeRenderer(CSwingTree aWidget) {
        this.mWidget = aWidget;
        this.mDefaultBackgroundSelectionColor = this.getBackgroundSelectionColor();
        this.mDefaultBackgroundNonSelectionColor = this.getBackgroundNonSelectionColor();
        this.mDefaultFont = this.getFont();
    }

    @Override
    public Component getTreeCellRendererComponent(JTree aTree, Object aValue, boolean aSelected, boolean aExpanded, boolean aLeaf, int aRowIndex, boolean aHasFocus) {
        Component component = super.getTreeCellRendererComponent(aTree, aValue, aSelected, aExpanded, aLeaf, aRowIndex, aHasFocus);
        if (component instanceof DefaultTreeCellRenderer) {
            DefaultTreeCellRenderer renderer = (DefaultTreeCellRenderer)component;
            if (aValue instanceof CSwingNode) {
                CSwingNode swingNode = (CSwingNode)aValue;
                CTreeNode node = swingNode.getNode();
                if (!this.mWidget.isUseSingleNodeRenderer()) {
                    renderer = new DefaultTreeCellRenderer();
                    component = renderer.getTreeCellRendererComponent(aTree, aValue, aSelected, aExpanded, aLeaf, aRowIndex, aHasFocus);
                }
                this.handleBackground(renderer, node);
                this.handleForeground(renderer, aSelected, node);
                this.handleBorder(renderer, node);
                this.handleFont(renderer, node);
                this.handleTooltip(renderer, node);
                this.handleIcon(renderer, node);
            }
        }
        return component;
    }

    private void handleIcon(DefaultTreeCellRenderer aRenderer, CTreeNode aNode) {
        ImageIcon icon = aNode.getIcon();
        if (icon != null) {
            aRenderer.setIcon(icon);
        }
    }

    private void handleTooltip(DefaultTreeCellRenderer aRenderer, CTreeNode aNode) {
        String tooltip = aNode.getTooltip();
        if (!tooltip.isEmpty()) {
            aRenderer.setToolTipText(tooltip);
        }
    }

    private void handleFont(DefaultTreeCellRenderer aComponent, CTreeNode aNode) {
        Font font = aNode.getFont();
        if (font != null) {
            aComponent.setFont(font);
        } else {
            aComponent.setFont(this.mDefaultFont);
        }
    }

    private void handleBorder(DefaultTreeCellRenderer aComponent, CTreeNode aNode) {
        Border border = aNode.getBorder();
        aComponent.setBorder(border);
    }

    private void handleForeground(DefaultTreeCellRenderer aComponent, boolean aSelected, CTreeNode aNode) {
        Color foreground = aNode.getForeground();
        if (foreground != null && !aSelected) {
            aComponent.setForeground(foreground);
        }
    }

    private void handleBackground(DefaultTreeCellRenderer aComponent, CTreeNode aNode) {
        Color background = aNode.getBackground();
        if (background != null) {
            aComponent.setBackgroundNonSelectionColor(background);
        } else {
            aComponent.setBackgroundNonSelectionColor(this.mDefaultBackgroundNonSelectionColor);
        }
    }
}

