/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget.menu;

import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingAbstractButton;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.menu.CSwingPopupMenu;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.events.CEventMenuNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventPopupNotification;
import de.sillysky.nyssr.util.swing.key.CUtilKeyCodes;
import de.sillysky.nyssr.util.swing.key.EKeyModifier;
import java.awt.Point;
import java.awt.event.ActionEvent;
import java.util.Collection;
import java.util.List;
import javax.swing.JCheckBoxMenuItem;
import javax.swing.JMenuItem;
import javax.swing.JRadioButtonMenuItem;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingMenuItem
extends CSwingAbstractButton {
    private JMenuItem mComponent;
    private boolean mOnPopup = false;

    public CSwingMenuItem(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        this.mComponent = new JMenuItem();
        this.addHandlers();
    }

    CSwingMenuItem(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        super(aWidgetSet, aId);
        this.addHandlers();
    }

    private void addHandlers() {
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("onPopup", this::applyOnPopup);
    }

    @Override
    public void addListeners() {
        this.getComponent().addActionListener(this::actionPerformed);
        super.addListeners();
    }

    private boolean applyOnPopup(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnPopup = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private CSwingPopupMenu findPopup() {
        CWidget p = this.getParent();
        while (p != null) {
            if (p instanceof CSwingPopupMenu) {
                return (CSwingPopupMenu)p;
            }
            p = this.getParent();
        }
        return null;
    }

    @NotNull
    public JMenuItem getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.MenuItem.name();
    }

    private void actionPerformed(ActionEvent aActionEvent) {
        JMenuItem c;
        JMenuItem component = this.getComponent();
        CWidgetSet ws = this.getWidgetSet();
        if (this.mOnPopup) {
            CWidgetId wid = null;
            Point point = null;
            int modifiers = aActionEvent.getModifiers();
            Collection mods = CUtilKeyCodes.getActionModifiers((int)modifiers);
            String actionCommand = component.getActionCommand();
            List popupEvents = ws.getContext().getPopupEvents();
            for (Object popupEvent : popupEvents) {
                if (popupEvent instanceof CWidgetId) {
                    wid = (CWidgetId)popupEvent;
                }
                if (!(popupEvent instanceof Point)) continue;
                point = (Point)popupEvent;
            }
            CEventPopupNotification event = new CEventPopupNotification();
            event.setCommand(actionCommand);
            for (EKeyModifier mod : mods) {
                event.addModifier(mod);
            }
            if (wid != null && point != null) {
                event.setPosition(point);
                event.setComponent(wid);
                CWidget widget = ws.getContext().findWidget(wid);
                if (widget != null) {
                    widget.enrichPopupEvent(event);
                }
            }
            Object jo = event.toJson();
            this.addNotification("onPopup", jo);
            this.sendNotification();
        }
        int modifiers = aActionEvent.getModifiers();
        Collection mods = CUtilKeyCodes.getActionModifiers((int)modifiers);
        String actionCommand = component.getActionCommand();
        boolean selected = false;
        if (component instanceof JCheckBoxMenuItem) {
            c = (JCheckBoxMenuItem)component;
            selected = ((JCheckBoxMenuItem)c).getState();
        } else if (component instanceof JRadioButtonMenuItem) {
            c = (JRadioButtonMenuItem)component;
            selected = c.isSelected();
        }
        CEventMenuNotification event = new CEventMenuNotification(actionCommand, mods, selected);
        Object jo = event.toJson();
        this.addNotification("onMenuChosen", jo);
        this.sendNotification();
    }
}

