/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.enums.EEditChangeType;
import de.sillysky.nyssr.remoteskin.model.events.CEventCaretNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventComponentOrientation;
import de.sillysky.nyssr.remoteskin.model.events.CEventMargin;
import de.sillysky.nyssr.remoteskin.model.events.CEventSelectText;
import de.sillysky.nyssr.remoteskin.model.events.CEventText;
import de.sillysky.nyssr.remoteskin.model.events.CEventTextChangeNotification;
import de.sillysky.nyssr.util.CUtilInteger;
import java.awt.Component;
import java.awt.ComponentOrientation;
import java.awt.print.PrinterException;
import javax.swing.event.DocumentEvent;
import javax.swing.event.DocumentListener;
import javax.swing.text.JTextComponent;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CSwingTextComponent
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingTextComponent.class);
    private boolean mOnTextChange;
    private boolean mOnCaretChange;

    CSwingTextComponent(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("caretColor", this::applyCaretColor);
        list.addHandler("caretPosition", this::applyCaretPosition);
        list.addHandler("clear", this::applyClear);
        list.addHandler("componentOrientation", this::applyComponentOrientation);
        list.addHandler("copy", this::applyCopy);
        list.addHandler("cut", this::applyCut);
        list.addHandler("disabledTextColor", this::applyDisabledTextColor);
        list.addHandler("editable", this::applyEditable);
        list.addHandler("margin", this::applyMargin);
        list.addHandler("paste", this::applyPaste);
        list.addHandler("print", this::applyPrint);
        list.addHandler("replaceSelection", this::applyReplaceSelection);
        list.addHandler("selectText", this::applySelectText);
        list.addHandler("selectionBackground", this::applySelectionBackground);
        list.addHandler("selectionForeground", this::applySelectionForeground);
        list.addHandler("text", this::applyText);
        list.addHandler("wantChange", this::applyWantChange);
        list.addHandler("wantCaretChange", this::applyWantCaretChange);
    }

    @Override
    public void addListeners() {
        super.addListeners();
        final JTextComponent tc = this.getTextComponent();
        if (tc != null) {
            tc.addCaretListener(e -> {
                if (this.mOnCaretChange) {
                    CEventCaretNotification event = new CEventCaretNotification(e.getDot(), e.getMark());
                    this.addNotification("onCaretChange", event.toJson());
                    this.sendNotification();
                }
            });
            tc.getDocument().addDocumentListener(new DocumentListener(){

                @Override
                public void insertUpdate(DocumentEvent e) {
                    this.sendNotification(e, EEditChangeType.insert);
                }

                @Override
                public void removeUpdate(DocumentEvent e) {
                    this.sendNotification(e, EEditChangeType.remove);
                }

                @Override
                public void changedUpdate(DocumentEvent e) {
                    this.sendNotification(e, EEditChangeType.change);
                }

                private void sendNotification(DocumentEvent e, EEditChangeType aType) {
                    if (CSwingTextComponent.this.mOnTextChange) {
                        int caretPosition = tc.getCaretPosition();
                        if (aType == EEditChangeType.change) {
                            ++caretPosition;
                        }
                        String text = tc.getText();
                        CEventTextChangeNotification event = new CEventTextChangeNotification(aType, text, e.getOffset(), e.getLength(), caretPosition);
                        Object jo = event.toJson();
                        CSwingTextComponent.this.addNotification("onTextChange", jo);
                        CSwingTextComponent.this.sendNotification();
                    }
                }
            });
        }
    }

    private boolean applyCaretColor(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event;
        JTextComponent tc = this.getTextComponent();
        if (tc != null && (event = CEventColor.create((Object)aValue)) != null) {
            tc.setCaretColor(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyCaretPosition(@NotNull String aKey, @Nullable Object aValue) {
        JTextComponent tc = this.getTextComponent();
        if (tc != null && (aValue instanceof Number || aValue instanceof String)) {
            int position = CUtilInteger.fromObject((Object)aValue, (int)-1);
            int length = tc.getDocument().getLength();
            if (position >= 0 && position <= length) {
                tc.setCaretPosition(position);
                return true;
            }
            LOG.error("Position out of range, length is {}", length);
        }
        return false;
    }

    private boolean applyClear(@NotNull String aKey, @Nullable Object aValue) {
        JTextComponent tc = this.getTextComponent();
        if (tc != null) {
            tc.setText(null);
            return true;
        }
        return false;
    }

    private boolean applyComponentOrientation(@NotNull String aKey, @Nullable Object aValue) {
        CEventComponentOrientation event;
        JTextComponent tc = this.getTextComponent();
        if (tc != null && (event = CEventComponentOrientation.create((Object)aValue)) != null) {
            switch (event.getComponentOrientation()) {
                case WesternEurope: {
                    tc.setComponentOrientation(ComponentOrientation.LEFT_TO_RIGHT);
                    break;
                }
                case MiddleEast: {
                    tc.setComponentOrientation(ComponentOrientation.RIGHT_TO_LEFT);
                    break;
                }
                default: {
                    tc.setComponentOrientation(ComponentOrientation.UNKNOWN);
                }
            }
            return true;
        }
        return false;
    }

    private boolean applyCopy(@NotNull String aKey, @Nullable Object aValue) {
        JTextComponent tc = this.getTextComponent();
        if (tc != null) {
            tc.copy();
            return true;
        }
        return false;
    }

    private boolean applyCut(@NotNull String aKey, @Nullable Object aValue) {
        JTextComponent tc = this.getTextComponent();
        if (tc != null) {
            tc.cut();
            return true;
        }
        return false;
    }

    private boolean applyDisabledTextColor(@NotNull String aKey, @Nullable Object aValue) {
        JTextComponent tc = this.getTextComponent();
        if (tc != null) {
            CEventColor event = CEventColor.create((Object)aValue);
            if (event != null) {
                tc.setDisabledTextColor(event.createColor());
            }
            return true;
        }
        return false;
    }

    private boolean applyEditable(@NotNull String aKey, @Nullable Object aValue) {
        JTextComponent tc;
        if (aValue instanceof Boolean && (tc = this.getTextComponent()) != null) {
            boolean b = (Boolean)aValue;
            tc.setEditable(b);
            return true;
        }
        return false;
    }

    private boolean applyMargin(@NotNull String aKey, @Nullable Object aValue) {
        CEventMargin event;
        JTextComponent tc = this.getTextComponent();
        if (tc != null && (event = CEventMargin.create((Object)aValue)) != null) {
            tc.setMargin(event.getMargin().toInsets());
            return true;
        }
        return false;
    }

    private boolean applyWantCaretChange(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnCaretChange = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyWantChange(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnTextChange = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyPaste(@NotNull String aKey, @Nullable Object aValue) {
        JTextComponent tc = this.getTextComponent();
        if (tc != null) {
            tc.paste();
            return true;
        }
        return false;
    }

    private boolean applyPrint(@NotNull String aKey, @Nullable Object aValue) throws PrinterException {
        JTextComponent tc = this.getTextComponent();
        if (tc != null) {
            tc.print();
            return true;
        }
        return false;
    }

    private boolean applyReplaceSelection(@NotNull String aKey, @Nullable Object aValue) {
        JTextComponent tc = this.getTextComponent();
        if (tc != null) {
            CEventText event = CEventText.create((Object)aValue);
            if (event != null) {
                tc.replaceSelection(event.getText());
            }
            return true;
        }
        return false;
    }

    private boolean applySelectText(@NotNull String aKey, @Nullable Object aValue) {
        CEventSelectText event;
        JTextComponent tc = this.getTextComponent();
        if (tc != null && (event = CEventSelectText.create((Object)aValue)) != null) {
            String currentText;
            int pos;
            int posStart = event.getPosStart();
            if (posStart >= 0) {
                int posEnd = event.getPosEnd();
                tc.select(posStart, posEnd);
                return true;
            }
            Boolean all = event.getAll();
            if (all != null && all.booleanValue()) {
                tc.selectAll();
                return true;
            }
            String text = event.getText();
            if (text != null && (pos = (currentText = tc.getText()).indexOf(text)) >= 0) {
                tc.select(pos, pos + text.length());
                return true;
            }
        }
        return false;
    }

    private boolean applySelectionBackground(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event;
        JTextComponent tc = this.getTextComponent();
        if (tc != null && (event = CEventColor.create((Object)aValue)) != null) {
            tc.setSelectionColor(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applySelectionForeground(@NotNull String aKey, @Nullable Object aValue) {
        CEventColor event;
        JTextComponent tc = this.getTextComponent();
        if (tc != null && (event = CEventColor.create((Object)aValue)) != null) {
            tc.setSelectedTextColor(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyText(@NotNull String aKey, @Nullable Object aValue) {
        CEventText event;
        JTextComponent tc = this.getTextComponent();
        if (tc != null && (event = CEventText.create((Object)aValue)) != null) {
            String s = event.getText();
            tc.setText(s);
            tc.setCaretPosition(0);
            return true;
        }
        return false;
    }

    @Nullable
    private JTextComponent getTextComponent() {
        Component component = this.getComponent();
        if (component instanceof JTextComponent) {
            return (JTextComponent)component;
        }
        LOG.warn("This is not a textComponent, this is as {}", new Object[]{component.getClass().getName()});
        return null;
    }
}

