/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.util.CUtilBoolean;
import de.sillysky.nyssr.util.CUtilInteger;
import java.awt.Container;
import javax.swing.JScrollPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingScrollPane
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingScrollPane.class);
    private final JScrollPane mComponent = new JScrollPane();

    CSwingScrollPane(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("blockIncrement", this::applyBlockIncrement);
        list.addHandler("horizontalBlockIncrement", this::applyHorizontalBlockIncrement);
        list.addHandler("horizontalUnitIncrement", this::applyHorizontalUnitIncrement);
        list.addHandler("opaque", this::applyOpaque);
        list.addHandler("unitIncrement", this::applyUnitIncrement);
        list.addHandler("verticalBlockIncrement", this::applyVerticalBlockIncrement);
        list.addHandler("verticalUnitIncrement", this::applyVerticalUnitIncrement);
    }

    @Override
    public void addChildComponent(@NotNull CWidget aChild) {
        JScrollPane pane = this.getComponent();
        pane.getViewport().setView(aChild.getComponent());
    }

    private boolean applyBlockIncrement(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            JScrollPane pane = this.getComponent();
            int inc = CUtilInteger.fromObject((Object)aValue, (int)30);
            LOG.debug("Set blockIncrement for horizontal and vertical ScrollBar to {}", new Object[]{inc});
            pane.getHorizontalScrollBar().setBlockIncrement(inc);
            pane.getVerticalScrollBar().setBlockIncrement(inc);
            return true;
        }
        return false;
    }

    private boolean applyHorizontalBlockIncrement(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            JScrollPane pane = this.getComponent();
            int inc = CUtilInteger.fromObject((Object)aValue, (int)30);
            LOG.debug("Set blockIncrement for horizontal ScrollBar to {}", new Object[]{inc});
            pane.getHorizontalScrollBar().setBlockIncrement(inc);
            return true;
        }
        return false;
    }

    private boolean applyHorizontalUnitIncrement(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            JScrollPane pane = this.getComponent();
            int inc = CUtilInteger.fromObject((Object)aValue, (int)30);
            LOG.debug("Set unitIncrement for horizontal ScrollBar to {}", new Object[]{inc});
            pane.getHorizontalScrollBar().setUnitIncrement(inc);
            return true;
        }
        return false;
    }

    private boolean applyOpaque(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean opaque = CUtilBoolean.fromObject((Object)aValue, (boolean)true);
            this.mComponent.setOpaque(opaque);
            this.mComponent.getViewport().setOpaque(opaque);
            Container parent = this.mComponent.getParent();
            if (parent != null) {
                this.mComponent.repaint();
            }
            return true;
        }
        return false;
    }

    private boolean applyUnitIncrement(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            JScrollPane pane = this.getComponent();
            int inc = CUtilInteger.fromObject((Object)aValue, (int)30);
            LOG.debug("Set unitIncrement for horizontal and vertical ScrollBar to {}", new Object[]{inc});
            pane.getHorizontalScrollBar().setUnitIncrement(inc);
            pane.getVerticalScrollBar().setUnitIncrement(inc);
            return true;
        }
        return false;
    }

    private boolean applyVerticalBlockIncrement(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            JScrollPane pane = this.getComponent();
            int inc = CUtilInteger.fromObject((Object)aValue, (int)30);
            LOG.debug("Set blockIncrement for vertical ScrollBar to {}", new Object[]{inc});
            pane.getVerticalScrollBar().setBlockIncrement(inc);
            return true;
        }
        return false;
    }

    private boolean applyVerticalUnitIncrement(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            JScrollPane pane = this.getComponent();
            int inc = CUtilInteger.fromObject((Object)aValue, (int)30);
            LOG.debug("Set unitIncrement for vertical ScrollBar to {}", new Object[]{inc});
            pane.getVerticalScrollBar().setUnitIncrement(inc);
            return true;
        }
        return false;
    }

    @NotNull
    public JScrollPane getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.ScrollPane.name();
    }
}

