/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.router.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNetworkGetNodeInfo
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"d1d851d1-9fa1-4456-8ac6-b3e6d31c6754");
    public static final String NAME = "NetworkGetNodeInfo";
    public static final String DESCRIPTION = "Get a description for one or all nodes. If the slots NODE and NODES are missing, all matching nodes will be returned.";
    public static final String SLOT_IS_REACHABLE = "3";
    public static final String SLOT_NODE = "1";
    public static final String SLOT_NODES = "2";
    public static final String SLOT_NODE_INFOS = "100";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static boolean getIsReachable(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_IS_REACHABLE);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static CNodeAddress getNode(@NotNull CRecord aRecord, CNodeAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODE);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress)slot.getValue();
    }

    public static CNodeAddress[] getNodes(@NotNull CRecord aRecord, CNodeAddress[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODES);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress[])slot.getValue();
    }

    public static CRecord[] getNodeInfos(@NotNull CRecord aRecord, CRecord[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NODE_INFOS);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord[])slot.getValue();
    }

    public static void setIsReachable(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN, (Object)aValue);
        aRecord.addSlot(SLOT_IS_REACHABLE, slot);
    }

    public static void setNode(@NotNull CRecord aRecord, CNodeAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_NODE, slot);
    }

    public static void setNodes(@NotNull CRecord aRecord, CNodeAddress[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_NODES, slot);
    }

    public static void setNodeInfos(@NotNull CRecord aRecord, CRecord[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_NODE_INFOS, slot);
    }
}

