/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

public final class CRecordNetworkIncomingMessage
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"4d38cfd1-12c3-4e14-9326-ee5782ad5782");
    public static final String NAME = "NetworkIncomingMessage";
    public static final String DESCRIPTION = "A Message came from a remote node and must be cleared before it can be send into the system.";
    public static final String SLOT_CONNECTION_ID = "1";
    public static final String SLOT_MESSAGE = "2";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static UUID getConnectionId(@NotNull CRecord aRecord, UUID aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CONNECTION_ID);
        if (slot == null) {
            return aDefault;
        }
        return (UUID)slot.getValue();
    }

    public static CMessage getMessage(@NotNull CRecord aRecord, CMessage aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MESSAGE);
        if (slot == null) {
            return aDefault;
        }
        return (CMessage)slot.getValue();
    }

    public static void setConnectionId(@NotNull CRecord aRecord, UUID aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.UUID, (Object)aValue);
        aRecord.addSlot(SLOT_CONNECTION_ID, slot);
    }

    public static void setMessage(@NotNull CRecord aRecord, CMessage aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.MESSAGE, (Object)aValue);
        aRecord.addSlot(SLOT_MESSAGE, slot);
    }
}

