/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.nodeinfo;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.network.nodeinfo.records.CRecordDataNodeInfo;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.util.CUtilString;
import java.time.ZonedDateTime;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CNodeInfo
implements Comparable<CNodeInfo> {
    private final CNodeAddress mNodeAddress;
    private final String mName;
    private final String mDescription;
    private final UUID mLicense;
    private final String mVendor;
    private final UUID mInstanceId;
    private final ZonedDateTime mStartTime;

    public CNodeInfo(@NotNull CNodeAddress aNodeAddress, @NotNull String aName, @NotNull String aDescription, @Nullable UUID aLicense, @NotNull String aVendor, @NotNull UUID aInstanceId, @NotNull ZonedDateTime aStartTime) {
        this.mNodeAddress = aNodeAddress;
        this.mName = aName;
        this.mDescription = aDescription;
        this.mLicense = aLicense;
        this.mVendor = aVendor;
        this.mInstanceId = aInstanceId;
        this.mStartTime = aStartTime;
    }

    @Nullable
    public static CNodeInfo create(@NotNull CRecord aRecord) {
        if (CRecordDataNodeInfo.ID.equals((Object)aRecord.getId())) {
            CNodeAddress node = CRecordDataNodeInfo.getNode(aRecord, null);
            String description = CRecordDataNodeInfo.getDescription(aRecord, "");
            UUID license = CRecordDataNodeInfo.getLicense(aRecord, null);
            String name = CRecordDataNodeInfo.getName(aRecord, "");
            if (name.isEmpty()) {
                name = node.getNodeId().toString();
            }
            String vendor = CRecordDataNodeInfo.getVendor(aRecord, "");
            String packetBuilderSequence = CRecordDataNodeInfo.getPacketBuilderSequence(aRecord, "M");
            UUID instanceId = CRecordDataNodeInfo.getInstanceId(aRecord, null);
            ZonedDateTime startTime = CRecordDataNodeInfo.getStartTime(aRecord, ZonedDateTime.now());
            if (node != null) {
                return new CNodeInfo(node, name, description, license, vendor, instanceId, startTime);
            }
        }
        return null;
    }

    @NotNull
    public CNodeAddress getNodeAddress() {
        return this.mNodeAddress;
    }

    @NotNull
    public String getName() {
        return this.mName;
    }

    @NotNull
    public String getDescription() {
        return this.mDescription;
    }

    @Nullable
    public UUID getLicense() {
        return this.mLicense;
    }

    @NotNull
    public String getVendor() {
        return this.mVendor;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CNodeInfo cNodeInfo = (CNodeInfo)aO;
        return this.mNodeAddress.equals((Object)cNodeInfo.mNodeAddress);
    }

    public int hashCode() {
        return Objects.hash(this.mNodeAddress);
    }

    @NotNull
    public CRecord toRecord() throws CException {
        CRecord record = CRecordDataNodeInfo.create();
        CRecordDataNodeInfo.setNode(record, this.mNodeAddress);
        CRecordDataNodeInfo.setDescription(record, this.mDescription);
        if (this.mLicense != null) {
            CRecordDataNodeInfo.setLicense(record, this.mLicense);
        }
        CRecordDataNodeInfo.setName(record, this.mName);
        CRecordDataNodeInfo.setVendor(record, this.mVendor);
        CRecordDataNodeInfo.setInstanceId(record, this.mInstanceId);
        return record;
    }

    public UUID getInstanceId() {
        return this.mInstanceId;
    }

    @Override
    public int compareTo(@NotNull CNodeInfo aNodeInfo) {
        return this.toString().compareTo(aNodeInfo.toString());
    }

    public String toString() {
        if (CUtilString.isValid((String)this.mName)) {
            return this.mName + " (" + this.mNodeAddress + ")";
        }
        return this.mNodeAddress.toString();
    }

    public ZonedDateTime getStartTime() {
        return this.mStartTime;
    }
}

