/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.dialog.user;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.dialog.user.CMainTarget;
import de.sillysky.nyssr.remoteskin.model.events.CEventButtonPressedNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventPasswordNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTextChangeNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventWindowNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IPasswordListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITextChangeListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IWindowClosingListener;
import de.sillysky.nyssr.session.api.CUser;
import de.sillysky.nyssr.util.CUtilString;
import org.jetbrains.annotations.NotNull;

class C703Handler {
    private final CMainTarget mMainTarget;
    private final IWidgetApi mApi;
    private final CWidgetSetId mWs703;
    private final CWidgetId m703Dialog;
    private final CWidgetId m703ButtonOkay;
    private final CWidgetId m703ButtonCancel;
    private final CWidgetId m703UserId;
    private final CWidgetId m703RealName;
    private final CWidgetId m703Email;
    private final CWidgetId m703Pw1;
    private final CWidgetId m703Pw2;
    private final CWidgetId m703LabelMessage;
    private final IRemoteSkinServerContext mServerContext;
    private final CUser mUser = new CUser();
    private String mEncodedPassword1 = "";
    private String mEncodedPassword2 = "";
    private boolean m703ButtonOkayIsEnabled;
    private boolean m703open;
    private CWidgetId mParentWidget;

    public C703Handler(@NotNull CMainTarget aMainTarget, @NotNull IRemoteSkinServerContext aServerContext, @NotNull String aInstance) {
        this.mMainTarget = aMainTarget;
        this.mServerContext = aServerContext;
        this.mApi = this.mServerContext.getWidgetApi();
        this.mWs703 = CWidgetSetId.create((String)"@703_CreateUser", (String)aInstance);
        this.m703Dialog = CWidgetId.create((String)"#703_Dialog", (CWidgetSetId)this.mWs703);
        this.mApi.addListener(this.m703Dialog, (IListener)((IWindowClosingListener)this::onDialogClosing));
        this.m703ButtonOkay = CWidgetId.create((String)"#703_ButtonOkay", (CWidgetSetId)this.mWs703);
        this.mApi.addListener(this.m703ButtonOkay, (IListener)((IButtonPressedListener)this::onButtonOkay));
        this.m703ButtonCancel = CWidgetId.create((String)"#703_ButtonCancel", (CWidgetSetId)this.mWs703);
        this.mApi.addListener(this.m703ButtonCancel, (IListener)((IButtonPressedListener)this::onButtonCancel));
        this.m703UserId = CWidgetId.create((String)"#703_TextFieldUserId", (CWidgetSetId)this.mWs703);
        this.mApi.addListener(this.m703UserId, (IListener)((ITextChangeListener)this::onTextChangeUserId));
        this.m703RealName = CWidgetId.create((String)"#703_TextFieldRealName", (CWidgetSetId)this.mWs703);
        this.mApi.addListener(this.m703RealName, (IListener)((ITextChangeListener)this::onTextChangeRealName));
        this.m703Email = CWidgetId.create((String)"#703_TextFieldEmail", (CWidgetSetId)this.mWs703);
        this.mApi.addListener(this.m703Email, (IListener)((ITextChangeListener)this::onTextChangeEmail));
        this.m703Pw1 = CWidgetId.create((String)"#703_PasswordField1", (CWidgetSetId)this.mWs703);
        this.mApi.addListener(this.m703Pw1, (IListener)((IPasswordListener)this::onPassword1));
        this.m703Pw2 = CWidgetId.create((String)"#703_PasswordField2", (CWidgetSetId)this.mWs703);
        this.mApi.addListener(this.m703Pw2, (IListener)((IPasswordListener)this::onPassword2));
        this.m703LabelMessage = CWidgetId.create((String)"#703_LabelMessage", (CWidgetSetId)this.mWs703);
    }

    private void onPassword1(@NotNull CEventPasswordNotification aEvent) {
        this.mEncodedPassword1 = aEvent.getEncodedPasswordBase64();
        this.check();
    }

    private void onPassword2(@NotNull CEventPasswordNotification aEvent) {
        this.mEncodedPassword2 = aEvent.getEncodedPasswordBase64();
        this.check();
    }

    private void check() {
        if (this.mEncodedPassword1.equals(this.mEncodedPassword2)) {
            this.mUser.setPassword(this.mEncodedPassword1);
            this.mApi.setText(this.m703LabelMessage, "Password okay");
            this.enableButtonOkay(CUtilString.isValid((String)this.mUser.getId()));
        } else {
            this.mApi.setText(this.m703LabelMessage, "Passwords are different");
            this.enableButtonOkay(false);
        }
        this.sendUpdate();
    }

    private void enableButtonOkay(boolean aEnabled) {
        if (this.m703ButtonOkayIsEnabled != aEnabled) {
            this.m703ButtonOkayIsEnabled = aEnabled;
            this.mApi.setEnabled(this.m703ButtonOkay, this.m703ButtonOkayIsEnabled);
        }
    }

    private void widgetSetMounted(@NotNull CWidgetSetId aWidgetSetId) {
        if (this.mWs703.equals((Object)aWidgetSetId)) {
            this.m703open = true;
            this.mApi.pack(this.m703Dialog);
            this.mApi.centerWidget(this.m703Dialog, this.mParentWidget);
            this.mApi.setVisible(this.m703Dialog, true);
            this.sendUpdate();
        }
    }

    private void onTextChangeUserId(@NotNull CEventTextChangeNotification aEvent) {
        this.mUser.setId(aEvent.getText());
        this.check();
    }

    private void onTextChangeRealName(@NotNull CEventTextChangeNotification aEvent) {
        this.mUser.setRealName(aEvent.getText());
    }

    private void onTextChangeEmail(@NotNull CEventTextChangeNotification aEvent) {
        this.mUser.setEmail(aEvent.getText());
    }

    private void onButtonOkay(@NotNull CEventButtonPressedNotification aEvent) throws CException {
        this.mMainTarget.sendAddUser(this.mUser);
    }

    private void onButtonCancel(@NotNull CEventButtonPressedNotification aEvent) {
        this.unmount();
    }

    private void onDialogClosing(@NotNull CEventWindowNotification aWindowEvent) {
        this.unmount();
    }

    void mount(@NotNull CWidgetId aParentWidget) {
        if (!this.m703open) {
            this.mParentWidget = aParentWidget;
            this.m703ButtonOkayIsEnabled = false;
            this.mServerContext.mountWidgetSet(this.mWs703, aParentWidget, "#703_PanelBackground", this::widgetSetMounted);
            this.sendUpdate();
        }
    }

    void unmount() {
        if (this.m703open) {
            this.m703open = false;
            this.mApi.unmount(this.m703Dialog);
            this.sendUpdate();
        }
    }

    void addMessage(@NotNull String aText) {
        this.mApi.setText(this.m703LabelMessage, aText);
    }

    void sendUpdate() {
        this.mServerContext.sendUpdate();
    }
}

