/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.context;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CExceptionLogger;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.remoteskin.client.context.CInstanceIdCreator;
import de.sillysky.nyssr.impl.remoteskin.client.context.CWidgetSetList;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CRootWidgetList;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetList;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinClientContext;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetSetMountedNotification;
import de.sillysky.nyssr.remoteskin.model.names.EPrivateWidgetNames;
import de.sillysky.nyssr.util.CUtilBoolean;
import de.sillysky.nyssr.util.time.stopwatch.CStopWatch;
import de.sillysky.nyssr.widget.parser.IRawWidgetSet;
import de.sillysky.nyssr.widget.parser.IRawWidgetSetList;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CWidgetSetMounter {
    private static final ILogger LOG = CLoggerFactory.getLogger(CWidgetSetMounter.class);
    private final CWidgetSetList mWidgetSetList;
    private final IRawWidgetSetList mRawWidgetSetList;
    private final CRootWidgetList mRootWidgetList;
    private final IRemoteSkinClientContext mContext;

    CWidgetSetMounter(@NotNull IRemoteSkinClientContext aContext, @NotNull IRawWidgetSetList aRawWidgetSetList, @NotNull CWidgetSetList aWidgetSetList, @NotNull CRootWidgetList aRootWidgetList) {
        this.mContext = aContext;
        this.mRawWidgetSetList = aRawWidgetSetList;
        this.mWidgetSetList = aWidgetSetList;
        this.mRootWidgetList = aRootWidgetList;
    }

    private void addWidgetsToWidgetSet(@NotNull CWidgetSet aSource, @NotNull CWidgetSet aDestination) {
        CWidgetList src = aSource.getWidgets();
        CWidgetList dest = aDestination.getWidgets();
        dest.addAll(src);
    }

    private void findAndReplacePlaceholder(@NotNull CWidgetSet aWidgetSet) throws Exception {
        CWidget ph = aWidgetSet.findPlaceHolder();
        while (ph != null) {
            if (!this.replacePlaceholder(aWidgetSet, ph)) {
                aWidgetSet.remove(ph);
            }
            ph = aWidgetSet.findPlaceHolder();
        }
    }

    @Nullable
    private CWidgetSet mountRegular(@Nullable CWidgetId aParent, @NotNull CWidgetSetId aWidgetSetIdToMount, @NotNull CTargetAddress aOwner) throws Exception {
        CWidget childRoot;
        CWidget parent = null;
        if (aParent != null && (parent = this.mWidgetSetList.findWidget(aParent)) == null) {
            LOG.error("Mount WidgetSet {}: Parent {} not found.", new Object[]{aWidgetSetIdToMount, aParent});
            return null;
        }
        CWidgetSet childSet = this.internalMount(parent, aWidgetSetIdToMount.getName(), aWidgetSetIdToMount.getInstance(), aOwner, false);
        if (parent != null && (childRoot = childSet.getRootWidget()) != null) {
            parent.addChildWidget(childRoot);
        }
        return childSet;
    }

    @NotNull
    private CWidgetSet mountReplacementSet(@NotNull String aWidgetSetNameToMount, @NotNull CTargetAddress aOwner, @NotNull CWidget aReplaceParent) throws Exception {
        CWidget childRoot;
        CWidget parent = aReplaceParent.getParent();
        String instanceIdOfPlaceHolder = aReplaceParent.getProperties().getProperty("instanceid");
        String s = aReplaceParent.getProperties().getProperty("childrenonly");
        boolean aChildrenOnly = CUtilBoolean.fromObject((Object)s, (boolean)false);
        CWidgetSet childSet = this.internalMount(parent, aWidgetSetNameToMount, instanceIdOfPlaceHolder, aOwner, aChildrenOnly);
        if (parent != null && (childRoot = childSet.getRootWidget()) != null) {
            parent.replaceChild(aReplaceParent, childRoot, aChildrenOnly);
        }
        return childSet;
    }

    @NotNull
    private CWidgetSet internalMount(@Nullable CWidget aParent, @NotNull String aWidgetSetNameToMount, @NotNull String aInstanceIdToMount, @NotNull CTargetAddress aOwner, boolean aChildrenOnly) throws Exception {
        IRawWidgetSet rawChild = this.mRawWidgetSetList.get(aWidgetSetNameToMount);
        if (rawChild == null) {
            throw new CException(5).append("WidgetSet not found: ").append(aWidgetSetNameToMount);
        }
        String instanceIdJson = rawChild.getInstanceIdFromJson();
        String instanceIdOfParentWidgetSet = aParent == null ? "" : aParent.getId().getWidgetSetId().getInstance();
        String instanceIdOfCommand = aInstanceIdToMount;
        String instanceId = CInstanceIdCreator.calculateInstanceId(instanceIdOfCommand, instanceIdOfParentWidgetSet, instanceIdJson);
        CWidgetSetId toMount = CWidgetSetId.create((String)aWidgetSetNameToMount, (String)instanceId);
        CWidgetSet childSet = this.createWidgetSet(toMount, aOwner, aParent, aChildrenOnly);
        this.mWidgetSetList.add(childSet);
        return childSet;
    }

    CWidgetSet mount(@Nullable CWidgetId aParent, @NotNull CWidgetSetId aWidgetSetIdToMount, @NotNull CTargetAddress aOwner, @Nullable UUID aTransactionId) throws Exception {
        CStopWatch watch = new CStopWatch().start();
        LOG.debug("Mount WidgetSet {}", new Object[]{aWidgetSetIdToMount});
        CWidgetSet widgetSet = this.mountRegular(aParent, aWidgetSetIdToMount, aOwner);
        if (widgetSet != null) {
            this.findAndReplacePlaceholder(widgetSet);
            CWidget rootWidget = widgetSet.getRootWidget();
            if (rootWidget != null) {
                rootWidget.createComponentTree(rootWidget.getParent());
                CWidgetSetId id = widgetSet.getId();
                CEventWidgetSetMountedNotification ev = new CEventWidgetSetMountedNotification(id, aTransactionId);
                CWidgetId wid = CWidgetId.create((String)EPrivateWidgetNames.widgetSet.name(), (CWidgetSetId)id);
                widgetSet.addNotification(wid, "widgetSetMounted", (Object)ev.toJson());
                widgetSet.sendNotifications();
            }
        }
        LOG.debug("WidgetSet {} mounted in {} ns", new Object[]{aWidgetSetIdToMount, watch.getAccumulatedTime()});
        return widgetSet;
    }

    private boolean replacePlaceholder(@NotNull CWidgetSet aWidgetSet, @NotNull CWidget aPlaceHolder) throws Exception {
        CWidgetId id = aPlaceHolder.getId();
        CWidget parent = aPlaceHolder.getParent();
        if (parent == null) {
            LOG.error("Mount: Parent of place holder is null: {}", new Object[]{id});
            return false;
        }
        CTargetAddress widgetSetOwner = aWidgetSet.getOwnerAddress();
        Object o = aPlaceHolder.getProperties().get("widgetsetname");
        if (o instanceof String) {
            CWidgetSet replacementSet = this.mountReplacementSet((String)o, widgetSetOwner, aPlaceHolder);
            CWidget replacementRoot = replacementSet.getRootWidget();
            if (replacementRoot == null) {
                LOG.error("Mount: Replacement found but has no root widget: replacement set = {}", new Object[]{id});
                return false;
            }
            aWidgetSet.replaceWidget(aPlaceHolder, replacementRoot, false);
            return true;
        }
        return false;
    }

    @NotNull
    private CWidgetSet createWidgetSet(@NotNull CWidgetSetId aWidgetSetIdToMount, @NotNull CTargetAddress aOwner, @Nullable CWidget aParent, boolean aChildrenOnly) throws Exception {
        CWidget childRoot;
        CWidgetSet childSet = this.mRawWidgetSetList.createWidgetSet(this.mContext, aWidgetSetIdToMount, aParent, aOwner);
        if (childSet == null) {
            CExceptionLogger.logAndThrow((Object)this, (int)5, (String)"Mount WidgetSet {0}: WidgetSet not found.", (Object[])new Object[]{aWidgetSetIdToMount});
        }
        if ((childRoot = childSet.getRootWidget()) == null) {
            CExceptionLogger.logAndThrow((Object)this, (int)5, (String)"Mount WidgetSet {0}: Root Child not found.", (Object[])new Object[]{aWidgetSetIdToMount});
        }
        if (aParent == null) {
            this.mRootWidgetList.add(childRoot);
        }
        return childSet;
    }
}

