/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.context;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.remoteskin.client.context.CRemoteSkinClientContext;
import de.sillysky.nyssr.impl.remoteskin.client.context.IFactory;
import de.sillysky.nyssr.json.IJsonParser;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.client.IRemoteSkinClientContextFactory;
import de.sillysky.nyssr.remoteskin.model.IRemoteSkinPlatformContext;
import de.sillysky.nyssr.remoteskin.model.IWidgetFactoryRegistry;
import de.sillysky.nyssr.remoteskin.model.command.IJsonCommandFactory;
import de.sillysky.nyssr.remoteskin.model.platform.IRemoteSkinPlatformRegistry;
import de.sillysky.nyssr.remoteskin.model.vars.IGlobalPropertyHolder;
import de.sillysky.nyssr.remoteskin.server.connector.IRemoteSkinClientContext;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceDependencyList;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.signal.properties.IPropertySignalDispatcher;
import de.sillysky.nyssr.widget.parser.IRawWidgetSetList;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CRemoteSkinClientContextFactory
implements IService,
IFactory,
IRemoteSkinClientContextFactory {
    private static final ILogger LOG = CLoggerFactory.getLogger(CRemoteSkinClientContextFactory.class);
    private final Map<IId, CRemoteSkinClientContext> mContexts = new ConcurrentHashMap<IId, CRemoteSkinClientContext>();
    private IWidgetFactoryRegistry mWidgetFactoryRegistry;
    private IRemoteSkinPlatformRegistry mClient;
    private IRawWidgetSetList mRawWidgetSetList;
    private IJsonCommandFactory mJsonCommandFactory;
    private IJsonParser mJsonParser;
    private IGlobalPropertyHolder mGlobalPropertyHolder;
    private IPropertySignalDispatcher mSystemSignalDispatcher;

    static void addDependencies(IServiceDependencyList aDependencyList) {
        aDependencyList.add(IWidgetFactoryRegistry.class);
        aDependencyList.add(IRemoteSkinPlatformRegistry.class);
        aDependencyList.add(IRawWidgetSetList.class);
        aDependencyList.add(IJsonCommandFactory.class);
        aDependencyList.add(IJsonParser.class);
        aDependencyList.add(IGlobalPropertyHolder.class);
        aDependencyList.add(IPropertySignalDispatcher.class);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) {
        this.mWidgetFactoryRegistry = (IWidgetFactoryRegistry)aServiceRegistry.getService(IWidgetFactoryRegistry.class);
        this.mClient = (IRemoteSkinPlatformRegistry)aServiceRegistry.getService(IRemoteSkinPlatformRegistry.class);
        this.mRawWidgetSetList = (IRawWidgetSetList)aServiceRegistry.getService(IRawWidgetSetList.class);
        this.mJsonCommandFactory = (IJsonCommandFactory)aServiceRegistry.getService(IJsonCommandFactory.class);
        this.mJsonParser = (IJsonParser)aServiceRegistry.getService(IJsonParser.class);
        this.mGlobalPropertyHolder = (IGlobalPropertyHolder)aServiceRegistry.getService(IGlobalPropertyHolder.class);
        this.mSystemSignalDispatcher = (IPropertySignalDispatcher)aServiceRegistry.getService(IPropertySignalDispatcher.class);
        aServiceRegistry.registerService(IRemoteSkinClientContextFactory.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    @Nullable
    public de.sillysky.nyssr.remoteskin.model.IRemoteSkinClientContext startContext(@NotNull IRemoteSkinClientContext aClientContext) {
        IId id = aClientContext.getId();
        CUtilCheck.checkNotNull((Object)id, (String)"Missing Context ID.", (Object[])new Object[0]);
        String platformType = aClientContext.getPlatformType();
        CUtilCheck.checkNotNull((Object)platformType, (String)"Missing Platform Type.", (Object[])new Object[0]);
        CTargetAddress address = aClientContext.getTargetAddress();
        CUtilCheck.checkNotNull((Object)address, (String)"Missing Owner.", (Object[])new Object[0]);
        IRemoteSkinPlatformContext platformContext = this.mClient.getPlatform(platformType);
        if (platformContext == null) {
            LOG.error("Unknown Platform {}", new Object[]{platformType});
            return null;
        }
        CRemoteSkinClientContext context = this.mContexts.get(id);
        if (context != null) {
            return context;
        }
        CRemoteSkinClientContext context1 = new CRemoteSkinClientContext();
        assert (this.mRawWidgetSetList != null);
        context1.activate(this, id, platformContext, address);
        this.mContexts.put(id, context1);
        return context1;
    }

    @Override
    public void stopContext(@NotNull IId aContextId) {
        CRemoteSkinClientContext context = this.mContexts.get(aContextId);
        if (context != null) {
            context.deactivate();
        }
    }

    @Override
    public IWidgetFactoryRegistry getWidgetFactoryRegistry() {
        return this.mWidgetFactoryRegistry;
    }

    @Override
    public IRawWidgetSetList getRawWidgetSetList() {
        return this.mRawWidgetSetList;
    }

    @Override
    public IJsonCommandFactory getJsonCommandFactory() {
        return this.mJsonCommandFactory;
    }

    @Override
    public IJsonParser getJsonParser() {
        return this.mJsonParser;
    }

    @Override
    public IGlobalPropertyHolder getGlobalPropertyHolder() {
        return this.mGlobalPropertyHolder;
    }

    @Override
    public IPropertySignalDispatcher getSystemSignalDispatcher() {
        return this.mSystemSignalDispatcher;
    }
}

