/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.helper.target;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.microservice.helper.target.IDependencies;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.microservice.registry.helper.records.CRecordNotifyMicroServiceRegistryCreated;
import de.sillysky.nyssr.microservice.registry.helper.records.CRecordNotifyMicroServiceRegistryDeleted;
import de.sillysky.nyssr.microservice.registry.records.CRecordMicroService;
import de.sillysky.nyssr.microservice.registry.records.CRecordRegisterMicroService;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import org.jetbrains.annotations.NotNull;

class CTargetForHelperForLocalMicroServices
extends CTarget
implements IService {
    @NotNull
    private final IDependencies mDependencies;
    private INamespace mNamespace;

    CTargetForHelperForLocalMicroServices(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNotifyMicroServiceRegistryCreated.ID, this::asyncNotifyMicroServiceRegistryCreated);
        this.addMessageHandler(CRecordNotifyMicroServiceRegistryDeleted.ID, this::asyncNotifyMicroServiceRegistryDeleted);
        this.addMessageHandler(CRecordRegisterMicroService.ID, this::asyncAnswerRegisterMicroServices);
        INamespaceFactory namespaceFactory = this.mDependencies.getNamespaceFactory();
        CUtilCheck.checkNotNull((Object)namespaceFactory, (String)"Missing Namespace Factory", (Object[])new Object[0]);
        this.mNamespace = namespaceFactory.createAndRegisterNamespace(CWellKnownNID.SYSTEM, "System");
        this.mNamespace.getTargetRegistry().registerTarget((ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        this.mDependencies.getPrivateHelperForLocalMicroServices().setTarget(null);
        this.mNamespace = null;
        aServiceRegistry.deregisterService((Object)this);
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        this.mDependencies.getPrivateHelperForLocalMicroServices().setTarget((ITarget)this);
        CTargetAddress address = this.getAddress();
        INanoServiceRegistry sr = this.mNamespace.getNanoServiceRegistry();
        sr.addObserver(CRecordNotifyMicroServiceRegistryCreated.ID, address);
        sr.addObserver(CRecordNotifyMicroServiceRegistryDeleted.ID, address);
        return true;
    }

    private boolean asyncNotifyMicroServiceRegistryCreated(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CTargetAddress address = CRecordNotifyMicroServiceRegistryCreated.getMicroServiceRegistryAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)address, (String)"Missing address", (Object[])new Object[0]);
        this.mDependencies.getPrivateHelperForLocalMicroServices().notifyMicroServiceRegistryAdded(address);
        return true;
    }

    private boolean asyncNotifyMicroServiceRegistryDeleted(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        CTargetAddress address = CRecordNotifyMicroServiceRegistryDeleted.getMicroServiceRegistryAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)address, (String)"Missing address", (Object[])new Object[0]);
        return true;
    }

    private boolean asyncAnswerRegisterMicroServices(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            CRecord record = CRecordRegisterMicroService.getMicroService((CRecord)aRecord, null);
            if (record != null) {
                IId iId = CRecordMicroService.getId((CRecord)record, null);
            }
            return true;
        }
        return false;
    }
}

