/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.microservice.registry.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordGetMicroServiceInstances
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"c5557e3e-2a2c-45c7-89b5-39d9286d317b");
    public static final String NAME = "GetMicroServiceInstances";
    public static final String DESCRIPTION = "Get the target addresses of the given Micro Service IDs. If more than one instance is registered, random instance are chosen.";
    public static final String SLOT_MICRO_SERVICE_IDS = "1";
    public static final String SLOT_MICRO_SERVICE_INSTANCES = "2";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static IId[] getMicroServiceIds(@NotNull CRecord aRecord, IId[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MICRO_SERVICE_IDS);
        if (slot == null) {
            return aDefault;
        }
        return (IId[])slot.getValue();
    }

    public static CRecord[] getMicroServiceInstances(@NotNull CRecord aRecord, CRecord[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MICRO_SERVICE_INSTANCES);
        if (slot == null) {
            return aDefault;
        }
        return (CRecord[])slot.getValue();
    }

    public static void setMicroServiceIds(@NotNull CRecord aRecord, IId[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_MICRO_SERVICE_IDS, slot);
    }

    public static void setMicroServiceInstances(@NotNull CRecord aRecord, CRecord[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.RECORD_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_MICRO_SERVICE_INSTANCES, slot);
    }
}

