/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.exception.CExceptionLogger;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingDialog;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.menu.CSwingMenuBar;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CUtilReference;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.util.swing.CIntegerToStringMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dialog;
import java.awt.Frame;
import java.awt.Window;
import javax.swing.JDialog;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingJDialog
extends CSwingDialog {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingJDialog.class);
    private static final CIntegerToStringMap mDefaultCloseOperations = new CIntegerToStringMap("DefaultCloseOperation");
    private JDialog mComponent;

    CSwingJDialog(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) throws Exception {
        super(aWidgetSet, aId);
        this.createComponent(aAttributes);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("defaultCloseOperation", this::applyDefaultCloseOperation);
    }

    @Override
    public void addChildComponent(@NotNull CWidget aChild) {
        if (aChild instanceof CSwingMenuBar) {
            CSwingMenuBar mb = (CSwingMenuBar)aChild;
            this.getComponent().setJMenuBar(mb.getComponent());
        } else {
            super.addChildComponent(aChild);
        }
    }

    private boolean applyDefaultCloseOperation(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            int action = mDefaultCloseOperations.get((String)aValue, 2);
            LOG.debug("Set {} to {}", new Object[]{aKey, action});
            this.getComponent().setDefaultCloseOperation(action);
            return true;
        }
        return false;
    }

    private void createComponent(@NotNull CJsonObject aAttributes) throws Exception {
        Object o = aAttributes.getValue("parent");
        CWidgetId wid = CUtilReference.parse((Object)o, (Object[])new Object[0]);
        if (wid == null) {
            this.mComponent = new JDialog();
        } else {
            CWidget parent = CUtilReference.findOrMountWidget((CWidget)this, (CWidgetId)wid);
            if (parent == null) {
                CExceptionLogger.logAndThrow((Object)this, (int)8, (String)"Parent {0} for JDialog not found.", (Object[])new Object[]{wid});
            } else {
                while (parent != null) {
                    Component component = parent.getComponent();
                    if (component instanceof Frame) {
                        this.mComponent = new JDialog((Frame)component);
                        break;
                    }
                    if (component instanceof Dialog) {
                        this.mComponent = new JDialog((Dialog)component);
                        break;
                    }
                    if (component instanceof Window) {
                        this.mComponent = new JDialog((Window)component);
                        break;
                    }
                    parent = parent.getParent();
                }
                if (this.mComponent == null) {
                    this.mComponent = new JDialog();
                }
            }
        }
    }

    @Override
    @NotNull
    public JDialog getComponent() {
        return this.mComponent;
    }

    @Override
    @Nullable
    public Container getContentPane() {
        return this.mComponent.getContentPane();
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.Dialog.name();
    }

    static {
        mDefaultCloseOperations.add("hide", 1);
        mDefaultCloseOperations.add("dispose", 2);
        mDefaultCloseOperations.add("nothing", 0);
    }
}

