/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.gatekeeper.records;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordDataGateKeeperRule
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"c5b55f25-7aa7-4f1f-a924-44881e90db51");
    public static final String NAME = "DataGateKeeperRule";
    public static final String DESCRIPTION = "A gatekeeper rule.";
    public static final String SLOT_DESCRIPTION = "1";
    public static final String SLOT_GATE = "3";
    public static final String SLOT_IS_ALLOW_RULE = "2";
    public static final String SLOT_RECEIVER_NID = "5";
    public static final String SLOT_RECORD_ID = "4";
    public static final String SLOT_SENDER_NODE_ID = "6";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getDescription(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_DESCRIPTION);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static int getGate(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_GATE);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static boolean getIsAllowRule(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_IS_ALLOW_RULE);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static IId getReceiverNid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_RECEIVER_NID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static IId getRecordId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_RECORD_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static CNodeId getSenderNodeId(@NotNull CRecord aRecord, CNodeId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SENDER_NODE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeId)slot.getValue();
    }

    public static void setDescription(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.STRING, (Object)aValue);
        aRecord.addSlot(SLOT_DESCRIPTION, slot);
    }

    public static void setGate(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.INT, (Object)aValue);
        aRecord.addSlot(SLOT_GATE, slot);
    }

    public static void setIsAllowRule(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN, (Object)aValue);
        aRecord.addSlot(SLOT_IS_ALLOW_RULE, slot);
    }

    public static void setReceiverNid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID, (Object)aValue);
        aRecord.addSlot(SLOT_RECEIVER_NID, slot);
    }

    public static void setRecordId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID, (Object)aValue);
        aRecord.addSlot(SLOT_RECORD_ID, slot);
    }

    public static void setSenderNodeId(@NotNull CRecord aRecord, CNodeId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ID, (Object)aValue);
        aRecord.addSlot(SLOT_SENDER_NODE_ID, slot);
    }
}

