/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.app.factory.collector;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.factory.collector.CConstantsAppFactoryCollector;
import de.sillysky.nyssr.app.factory.collector.records.CRecordAddAppFactory;
import de.sillysky.nyssr.app.factory.collector.records.CRecordGetApplicationListForUser;
import de.sillysky.nyssr.app.factory.collector.records.CRecordLaunchApplication;
import de.sillysky.nyssr.app.factory.collector.records.CRecordRemoveAppFactory;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.app.factory.collector.CAppCollectorUtils;
import de.sillysky.nyssr.impl.app.factory.collector.CApplicationEntry;
import de.sillysky.nyssr.impl.app.factory.collector.CApplicationFactoryEntry;
import de.sillysky.nyssr.impl.app.factory.collector.CApplicationFactoryList;
import de.sillysky.nyssr.impl.app.factory.collector.CTargetGetApplicationList;
import de.sillysky.nyssr.impl.app.factory.collector.CTargetRunApplication;
import de.sillysky.nyssr.impl.app.factory.collector.IDependencies;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.kernel.records.CRecordAvailable;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.nanoservice.INanoServiceRegistry;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeAdded;
import de.sillysky.nyssr.notification.records.CRecordNotifyRemoteNodeRemoved;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordNotifyTargetDeregistered;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;

class CAppFactoryCollector
extends CTarget
implements IService {
    private static final ILogger LOG = CLoggerFactory.getLogger(CAppFactoryCollector.class);
    private final IDependencies mDependencies;
    private final IId mInstanceId = CIdFactory.randomOfType((EIdType)EIdType.UUID);
    private final CApplicationFactoryList mFactoryList = new CApplicationFactoryList();

    CAppFactoryCollector(@NotNull IDependencies aDependencies) {
        this.mDependencies = aDependencies;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordAddAppFactory.ID, this::asyncAddAppFactory);
        this.addMessageHandler(CRecordRemoveAppFactory.ID, this::asyncRemoveAppFactory);
        this.addMessageHandler(CRecordLaunchApplication.ID, this::asyncRunApplication);
        this.addMessageHandler(CRecordGetApplicationListForUser.ID, this::asyncGetApplicationListForUser);
        this.addMessageHandler(CRecordNotifyRemoteNodeRemoved.ID, this::asyncNotifyRemoteNodeRemoved);
        this.addMessageHandler(CRecordNotifyRemoteNodeAdded.ID, this::asyncNotifyRemoteNodeAdded);
        this.addMessageHandler(CRecordNotifyTargetDeregistered.ID, this::asyncNotifyTargetDeregistered);
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        CAppCollectorUtils.registerTarget(this.mDependencies, (ITarget)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        CAppCollectorUtils.deregisterMicroservice(this.mDependencies, this.mInstanceId);
        this.sendAvailable(false);
        this.deregisterTarget();
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        CAppCollectorUtils.registerMicroservice(this.mDependencies, this.mInstanceId, this.getAddress());
        INamespace system = this.mDependencies.getNamespaceFactory().getNamespace(CWellKnownNID.SYSTEM);
        assert (system != null);
        INanoServiceRegistry nsr = system.getNanoServiceRegistry();
        nsr.addObserver(CRecordNotifyRemoteNodeAdded.class, this.getAddress(), true);
        nsr.addObserver(CRecordNotifyRemoteNodeRemoved.class, this.getAddress(), false);
        nsr.addObserver(CRecordNotifyTargetDeregistered.class, this.getAddress(), false);
        this.sendAvailable(true);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncNotifyRemoteNodeAdded(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (!aEnvelope.isAnswer()) {
            CNodeAddress remoteNode = CRecordNotifyRemoteNodeAdded.getRemoteNode((CRecord)aRecord, null);
            this.sendAvailable(remoteNode);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncNotifyRemoteNodeRemoved(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (!aEnvelope.isAnswer()) {
            CNodeAddress remoteNode = CRecordNotifyRemoteNodeRemoved.getRemoteNode((CRecord)aRecord, null);
            this.mFactoryList.notifyRemoteNodeRemoved(remoteNode);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncNotifyTargetDeregistered(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (!aEnvelope.isAnswer()) {
            CTargetAddress address = CRecordNotifyTargetDeregistered.getAddress((CRecord)aRecord, null);
            this.mFactoryList.notifyTargetRemoved(address);
            aEnvelope.setResultSuccess();
        }
        return true;
    }

    private boolean asyncAddAppFactory(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CRecord appRecord = CRecordAddAppFactory.getApplication((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)appRecord, (String)"Missing application record", (Object[])new Object[0]);
        CApplicationEntry appEntry = CAppCollectorUtils.unpackApplication(appRecord);
        CTargetAddress factoryAddress = CRecordAddAppFactory.getFactoryAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)factoryAddress, (String)"Missing factory address", (Object[])new Object[0]);
        CApplicationFactoryEntry entry = new CApplicationFactoryEntry(appEntry);
        entry.addFactory(factoryAddress);
        if (this.mFactoryList.add(appEntry, factoryAddress)) {
            LOG.info("App Factory Registered: {}", new Object[]{appEntry.getApplicationName()});
        } else {
            LOG.debug("App Factory already registered: {}", new Object[]{appEntry.getApplicationName()});
        }
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRemoveAppFactory(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        UUID applicationId = CRecordRemoveAppFactory.getApplicationId((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)applicationId, (String)"Missing application ID", (Object[])new Object[0]);
        CTargetAddress factoryAddress = CRecordRemoveAppFactory.getFactoryAddress((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)factoryAddress, (String)"Missing factory address", (Object[])new Object[0]);
        if (this.mFactoryList.removeFactory(applicationId, factoryAddress)) {
            aEnvelope.setResultSuccess();
        } else {
            aEnvelope.setResult(5, "Not found");
        }
        return true;
    }

    private boolean asyncRunApplication(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        UUID applicationId = CRecordLaunchApplication.getApplicationId((CRecord)aRecord, null);
        CUtilCheck.checkNotNullEx((Object)applicationId, (String)"Missing application ID", (Object[])new Object[0]);
        byte[] sessionToken = aEnvelope.getSessionToken();
        CTargetRunApplication tgt = new CTargetRunApplication(this.mFactoryList, aEnvelope, aRecord);
        this.getTargetRegistry().registerTarget((ITarget)tgt);
        return true;
    }

    private boolean asyncGetApplicationListForUser(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        byte[] sessionToken = aEnvelope.getSessionToken();
        CUtilCheck.checkNotNullEx((Object)sessionToken, (String)"Missing session token", (Object[])new Object[0]);
        String platform = CRecordGetApplicationListForUser.getPlatform((CRecord)aRecord, (String)"");
        CUtilCheck.checkEmptyString((Object)platform, (String)"Missing application platform", (Object[])new Object[0]);
        CTargetGetApplicationList tgt = new CTargetGetApplicationList(this.mFactoryList, aEnvelope, aRecord);
        this.getTargetRegistry().registerTarget((ITarget)tgt);
        return true;
    }

    private void sendAvailable(@NotNull CNodeAddress aNode) throws CException {
        CEnvelope env = CEnvelope.forRemoteNanoService(CRecordAvailable.class, (CNodeAddress)aNode);
        CRecord record = CRecordAvailable.create();
        CRecordAvailable.setId((CRecord)record, (IId)CConstantsAppFactoryCollector.MICROSERVICE_ID);
        CRecordAvailable.setAvailable((CRecord)record, (boolean)true);
        this.sendNotification(env, record);
    }

    private void sendAvailable(boolean aAvailable) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService(CRecordAvailable.class);
        CRecord record = CRecordAvailable.create();
        CRecordAvailable.setId((CRecord)record, (IId)CConstantsAppFactoryCollector.MICROSERVICE_ID);
        CRecordAvailable.setAvailable((CRecord)record, (boolean)aAvailable);
        this.mDependencies.getBroadcastService().broadcastMessage(env, record, true);
    }
}

