/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.windowpositions;

import de.sillysky.nyssr.impl.remoteskin.client.swing.util.CUtilToolset;
import de.sillysky.nyssr.remoteskin.IWindowPositioner;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import java.awt.Dimension;
import java.awt.GraphicsConfiguration;
import java.awt.GraphicsDevice;
import java.awt.GraphicsEnvironment;
import java.awt.Point;
import java.awt.Rectangle;
import org.jetbrains.annotations.NotNull;

public class CWindowPositioner
implements IService,
IWindowPositioner {
    private Rectangle mRectangle;
    private int mPosition = 0;

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws Exception {
        GraphicsEnvironment ge = GraphicsEnvironment.getLocalGraphicsEnvironment();
        GraphicsDevice gd = ge.getDefaultScreenDevice();
        GraphicsConfiguration gc = gd.getDefaultConfiguration();
        this.mRectangle = CUtilToolset.getEffectiveScreenSize(gc);
        aServiceRegistry.registerService(IWindowPositioner.class, (Object)this);
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        aServiceRegistry.deregisterService((Object)this);
    }

    @Override
    @NotNull
    public Point getNextPosition(@NotNull Dimension aWindowDimensions) {
        int height = this.mRectangle.height;
        int width = this.mRectangle.width;
        int p = 0;
        for (int x = 0; x < width; x += width / 10) {
            for (int y = 0; y < height; y += height / 10) {
                if (p == this.mPosition) {
                    ++this.mPosition;
                    if (x + aWindowDimensions.width <= width + 10 && y + aWindowDimensions.height <= height + 10) {
                        return new Point(x + this.mRectangle.x, y + this.mRectangle.y);
                    }
                }
                ++p;
            }
        }
        this.mPosition = 1;
        return new Point(this.mRectangle.x, this.mRectangle.y);
    }
}

