/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.events.CWindowEvent;
import de.sillysky.nyssr.impl.remoteskin.client.swing.util.CUtilToolset;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingContainer;
import de.sillysky.nyssr.impl.service.CServiceRegistry;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.IWindowPositioner;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CUtilCursor;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventInt2;
import de.sillysky.nyssr.remoteskin.model.events.CEventRectangle;
import de.sillysky.nyssr.remoteskin.model.events.CEventWidgetId;
import de.sillysky.nyssr.util.CUtilFloat;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.swing.CIntegerToStringMap;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.Dialog;
import java.awt.Dimension;
import java.awt.Frame;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.Window;
import java.awt.event.FocusEvent;
import java.awt.event.FocusListener;
import java.awt.event.WindowEvent;
import java.awt.event.WindowListener;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public abstract class CSwingWindow
extends CSwingContainer {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingWindow.class);
    private static final CIntegerToStringMap mModalExclusionType = new CIntegerToStringMap("ModalExclusionType");
    private final Window mWindow;
    private boolean mOnWindowClosing = false;
    private boolean mOnWindowOpened = false;
    private boolean mOnWindowDeiconified = false;
    private boolean mOnWindowActivated = false;
    private boolean mOnWindowDeactivated = false;
    private boolean mOnWindowIconified = false;
    private boolean mOnWindowClosed = false;
    private boolean mOnWindowStateChanged = false;
    private boolean mOnFocusGained = false;
    private boolean mOnFocusLost = false;
    private boolean mOptimizeLocation = true;
    private boolean mPack = false;

    CSwingWindow(@NotNull CWidgetSet aWidgetSet, @NotNull String aId) {
        super(aWidgetSet, aId);
        this.mWindow = null;
        this.addHandlers();
    }

    CSwingWindow(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull Frame aParent) {
        super(aWidgetSet, aId);
        this.mWindow = new Window(aParent);
        this.addHandlers();
    }

    CSwingWindow(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull Window aParent) {
        super(aWidgetSet, aId);
        this.mWindow = new Window(aParent);
        this.addHandlers();
    }

    @NotNull
    public Component getComponent() {
        return this.mWindow;
    }

    private void addHandlers() {
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("alwaysOnTop", this::applyAlwaysOnTop);
        list.addHandler("autoRequestFocus", this::applyAutoRequestFocus);
        list.addHandler("background", this::applyBackground);
        list.addHandler("bounds", this::applyBounds);
        list.addHandler("centerWindowToWidget", this::applyCenterWindowToWidget);
        list.addHandler("centerWindowToScreen", this::applyCenterWindowToScreen);
        list.addHandler("cursor", this::applyCursor);
        list.addHandler("focusableWindowState", this::applyFocusableWindowState);
        list.addHandler("focusCycleRoot", this::applyFocusCycleRoot);
        list.addHandler("location", this::applyLocation);
        list.addHandler("locationByPlatform", this::applyLocationByPlatform);
        list.addHandler("modalExclusionType", this::applyModalExclusionType);
        list.addHandler("onWindowGainedFocus", this::applyOnFocusGained);
        list.addHandler("onWindowLostFocus", this::applyOnFocusLost);
        list.addHandler("onWindowActivated", this::applyOnWindowActivated);
        list.addHandler("onWindowClosed", this::applyOnWindowClosed);
        list.addHandler("onWindowClosing", this::applyOnWindowClosing);
        list.addHandler("onWindowDeactivated", this::applyOnWindowDeactivated);
        list.addHandler("onWindowDeIconified", this::applyOnWindowDeiconified);
        list.addHandler("onWindowIconified", this::applyOnWindowIconified);
        list.addHandler("onWindowOpened", this::applyOnWindowOpened);
        list.addHandler("onWindowStateChanged", this::applyOnWindowStateChanged);
        list.addHandler("opacity", this::applyOpacity);
        list.addHandler("optimizeLocation", this::applyOptimizeLocation);
        list.addHandler("pack", this::applyPack);
        list.addHandler("visible", this::applyVisible);
        list.addHandler("windowType", this::applyWindowType);
    }

    private boolean applyOptimizeLocation(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOptimizeLocation = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyAlwaysOnTop(@NotNull String aKey, @Nullable Object aValue) {
        Component component;
        if (aValue instanceof Boolean && (component = this.getComponent()) instanceof Window) {
            Window window = (Window)component;
            boolean onTop = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, onTop});
            window.setAlwaysOnTop(onTop);
            return true;
        }
        return false;
    }

    private boolean applyAutoRequestFocus(@NotNull String aKey, @Nullable Object aValue) {
        Component component;
        if (aValue instanceof Boolean && (component = this.getComponent()) instanceof Window) {
            Window window = (Window)component;
            boolean auto = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, auto});
            window.setAutoRequestFocus(auto);
            return true;
        }
        return false;
    }

    private boolean applyBackground(@NotNull String aKey, @Nullable Object aValue) {
        Container contentPane;
        CEventColor event = CEventColor.create((Object)aValue);
        if (event != null && (contentPane = this.getContentPane()) != null) {
            LOG.debug("Set {} to {}", new Object[]{aKey, event.createColor()});
            contentPane.setBackground(event.createColor());
            return true;
        }
        return false;
    }

    private boolean applyBounds(@NotNull String aKey, @Nullable Object aValue) {
        Component component = this.getComponent();
        if (component instanceof Window) {
            Window window = (Window)component;
            CEventRectangle event = CEventRectangle.create((Object)aValue);
            if (event != null) {
                Rectangle rectangle = event.getRectangle();
                LOG.debug("Set {} to {}", new Object[]{aKey, rectangle});
                window.setBounds(rectangle);
                return true;
            }
        }
        return false;
    }

    private boolean applyCenterWindowToWidget(@NotNull String aKey, @Nullable Object aValue) {
        CWidget widget;
        CEventWidgetId event;
        Component component = this.getComponent();
        if (component instanceof Window && (event = CEventWidgetId.create((Object)aValue)) != null && (widget = this.getWidgetSet().getContext().findWidget(event.getWidgetId())) != null) {
            Component parent = widget.getComponent();
            Dimension sizeWidget = component.getSize();
            Point locationParent = parent.getLocationOnScreen();
            Dimension sizeParent = parent.getSize();
            int x = locationParent.x + sizeParent.width / 2 - sizeWidget.width / 2;
            int y = locationParent.y + sizeParent.height / 2 - sizeWidget.height / 2;
            component.setLocation(x, y);
            return true;
        }
        return false;
    }

    private boolean applyCenterWindowToScreen(@NotNull String aKey, @Nullable Object aValue) {
        Component component;
        if (aValue instanceof Boolean && (component = this.getComponent()) instanceof Window) {
            Window window = (Window)component;
            boolean doCenter = (Boolean)aValue;
            if (doCenter) {
                Rectangle boundsComponent = window.getBounds();
                Rectangle boundsScreen = CUtilToolset.getScreenBoundsFor(boundsComponent);
                this.centerComponent(boundsScreen);
            }
            return true;
        }
        return false;
    }

    private boolean applyCursor(@NotNull String aKey, @Nullable Object aValue) {
        Component component = this.getComponent();
        if (component instanceof Window) {
            Window window = (Window)component;
            int cursor = CUtilCursor.parse((Object)aValue);
            LOG.debug("Set {} to {}", new Object[]{aKey, aValue});
            window.setCursor(new Cursor(cursor));
            return true;
        }
        return false;
    }

    private boolean applyFocusCycleRoot(@NotNull String aKey, @Nullable Object aValue) {
        Component component;
        if (aValue instanceof Boolean && (component = this.getComponent()) instanceof Window) {
            Window window = (Window)component;
            boolean val = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, val});
            window.setFocusCycleRoot(val);
            return true;
        }
        return false;
    }

    private boolean applyFocusableWindowState(@NotNull String aKey, @Nullable Object aValue) {
        Component component;
        if (aValue instanceof Boolean && (component = this.getComponent()) instanceof Window) {
            Window window = (Window)component;
            boolean val = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, val});
            window.setFocusableWindowState(val);
            return true;
        }
        return false;
    }

    private boolean applyLocation(@NotNull String aKey, @Nullable Object aValue) {
        Component component = this.getComponent();
        if (component instanceof Window) {
            Window window = (Window)component;
            CEventInt2 event = CEventInt2.create((Object)aValue);
            if (event != null) {
                Point p = new Point(event.getValue0(), event.getValue1());
                LOG.debug("Set {} to {}", new Object[]{aKey, p});
                window.setLocation(p);
                return true;
            }
        }
        return false;
    }

    private boolean applyLocationByPlatform(@NotNull String aKey, @Nullable Object aValue) {
        Component component;
        if (aValue instanceof Boolean && (component = this.getComponent()) instanceof Window) {
            Window window = (Window)component;
            boolean loc = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, loc});
            window.setLocationByPlatform(loc);
            return true;
        }
        return false;
    }

    private boolean applyModalExclusionType(@NotNull String aKey, @Nullable Object aValue) {
        Component component = this.getComponent();
        if (component instanceof Window) {
            Window window = (Window)component;
            if (aValue instanceof String) {
                int met = mModalExclusionType.get((String)aValue, Dialog.ModalExclusionType.NO_EXCLUDE.ordinal());
                Dialog.ModalExclusionType m = Dialog.ModalExclusionType.values()[met];
                LOG.debug("Set {} to {}", new Object[]{aKey, m});
                window.setModalExclusionType(m);
                return true;
            }
        }
        return false;
    }

    private boolean applyOnWindowActivated(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnWindowActivated = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnWindowClosed(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnWindowClosed = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnWindowClosing(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnWindowClosing = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnWindowDeactivated(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnWindowDeactivated = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnWindowDeiconified(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnWindowDeiconified = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnFocusGained(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnFocusGained = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnWindowIconified(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnWindowIconified = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnFocusLost(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnFocusLost = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnWindowOpened(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnWindowOpened = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOnWindowStateChanged(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mOnWindowStateChanged = (Boolean)aValue;
            return true;
        }
        return false;
    }

    private boolean applyOpacity(@NotNull String aKey, @Nullable Object aValue) {
        Component component;
        if (aValue instanceof Number && (component = this.getComponent()) instanceof Window) {
            Window window = (Window)component;
            float opacity = CUtilFloat.fromObject((Object)aValue);
            LOG.debug("Set Attribute {}: {}", new Object[]{aKey, Float.valueOf(opacity)});
            window.setOpacity(opacity);
            return true;
        }
        return false;
    }

    public void pack() {
        Component component;
        if (this.mPack && (component = this.getComponent()) instanceof Window) {
            Window window = (Window)component;
            window.pack();
            if (this.mOptimizeLocation) {
                Dimension size = window.getSize();
                IWindowPositioner p = (IWindowPositioner)CServiceRegistry.getInstance().getService(IWindowPositioner.class);
                if (p != null) {
                    Point pos = p.getNextPosition(size);
                    window.setLocation(pos);
                    this.mOptimizeLocation = false;
                }
            }
        }
    }

    private boolean applyPack(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            this.mPack = (Boolean)aValue;
            this.pack();
            return true;
        }
        return false;
    }

    private boolean applyVisible(@NotNull String aKey, @Nullable Object aValue) {
        Component component;
        if (aValue instanceof Boolean && (component = this.getComponent()) instanceof Window) {
            Window window = (Window)component;
            boolean visible = (Boolean)aValue;
            LOG.debug("Set {} to {}", new Object[]{aKey, visible});
            window.setVisible(visible);
            return true;
        }
        return false;
    }

    private boolean applyWindowType(@NotNull String aKey, @Nullable Object aValue) {
        Component component = this.getComponent();
        if (component instanceof Window) {
            Window window = (Window)component;
            if (aValue instanceof String) {
                Window.Type t;
                String value;
                switch (value = (String)aValue) {
                    case "normal": {
                        t = Window.Type.NORMAL;
                        break;
                    }
                    case "popup": {
                        t = Window.Type.POPUP;
                        break;
                    }
                    case "utility": {
                        t = Window.Type.UTILITY;
                        break;
                    }
                    default: {
                        LOG.error("Unsupported WindowType {}, use 'normal', 'popup' or 'utility'", new Object[]{value});
                        return false;
                    }
                }
                LOG.debug("Set {} to {}", new Object[]{aKey, value});
                window.setType(t);
            }
            return true;
        }
        return false;
    }

    private void centerComponent(Rectangle aBoundsParent) {
        Component component = this.getComponent();
        if (component instanceof Window) {
            Window window = (Window)component;
            Rectangle boundsComponent = window.getBounds();
            double x = aBoundsParent.getCenterX() - (double)boundsComponent.width / 2.0;
            double y = aBoundsParent.getCenterY() - (double)boundsComponent.height / 2.0;
            Rectangle newBounds = new Rectangle((int)x, (int)y, boundsComponent.width, boundsComponent.height);
            LOG.debug("Center window to {}", new Object[]{newBounds});
            window.setBounds(newBounds);
        }
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.Window.name();
    }

    public void notifyComponentCreated() {
        this.getWidgetSet().getContext().addRootWidget((CWidget)this);
        super.notifyComponentCreated();
    }

    public void unmount() {
        Component component = this.getComponent();
        if (component instanceof Window) {
            Window window = (Window)component;
            window.dispose();
        }
        super.unmount();
    }

    @Override
    public void addListeners() {
        super.addListeners();
        Component component = this.getComponent();
        if (component instanceof Window) {
            Window window = (Window)component;
            window.addWindowStateListener(aEvent -> {
                if (this.mOnWindowStateChanged) {
                    CWindowEvent.sendEvent(this, "onWindowStateChanged", aEvent);
                }
            });
            window.addFocusListener(new FocusListener(){

                @Override
                public void focusGained(FocusEvent aEvent) {
                    if (CSwingWindow.this.mOnFocusGained) {
                        CSwingWindow.this.sendFocusEvent("onWindowGainedFocus", aEvent);
                    }
                }

                @Override
                public void focusLost(FocusEvent aEvent) {
                    if (CSwingWindow.this.mOnFocusLost) {
                        CSwingWindow.this.sendFocusEvent("onWindowLostFocus", aEvent);
                    }
                }
            });
            window.addWindowListener(new WindowListener(){

                @Override
                public void windowOpened(WindowEvent aEvent) {
                    if (CSwingWindow.this.mOnWindowOpened) {
                        CWindowEvent.sendEvent(CSwingWindow.this, "onWindowOpened", aEvent);
                    }
                }

                @Override
                public void windowClosing(WindowEvent aEvent) {
                    if (CSwingWindow.this.mOnWindowClosing) {
                        CWindowEvent.sendEvent(CSwingWindow.this, "onWindowClosing", aEvent);
                    }
                }

                @Override
                public void windowClosed(WindowEvent aEvent) {
                    if (CSwingWindow.this.mOnWindowClosed) {
                        CWindowEvent.sendEvent(CSwingWindow.this, "onWindowClosed", aEvent);
                    }
                }

                @Override
                public void windowIconified(WindowEvent aEvent) {
                    if (CSwingWindow.this.mOnWindowIconified) {
                        CWindowEvent.sendEvent(CSwingWindow.this, "onWindowIconified", aEvent);
                    }
                }

                @Override
                public void windowDeiconified(WindowEvent aEvent) {
                    if (CSwingWindow.this.mOnWindowDeiconified) {
                        CWindowEvent.sendEvent(CSwingWindow.this, "onWindowDeIconified", aEvent);
                    }
                }

                @Override
                public void windowActivated(WindowEvent aEvent) {
                    if (CSwingWindow.this.mOnWindowActivated) {
                        CWindowEvent.sendEvent(CSwingWindow.this, "onWindowActivated", aEvent);
                    }
                }

                @Override
                public void windowDeactivated(WindowEvent aEvent) {
                    if (CSwingWindow.this.mOnWindowDeactivated) {
                        CWindowEvent.sendEvent(CSwingWindow.this, "onWindowDeactivated", aEvent);
                    }
                }
            });
        }
    }

    private void sendFocusEvent(@NotNull String aRsEvent, @NotNull FocusEvent aFocusEvent) {
        String name;
        CJsonObject jo = new CJsonObject(true);
        Component opposite = aFocusEvent.getOppositeComponent();
        if (opposite != null && CUtilString.isValid((String)(name = opposite.getName()))) {
            jo.put("OPPOSITE", (Object)name);
        }
        jo.put("temporary", (Object)aFocusEvent.isTemporary());
        this.addNotification(aRsEvent, jo);
        this.sendNotification();
    }

    static {
        mModalExclusionType.add("application", Dialog.ModalExclusionType.APPLICATION_EXCLUDE.ordinal());
        mModalExclusionType.add("no", Dialog.ModalExclusionType.NO_EXCLUDE.ordinal());
        mModalExclusionType.add("toolkit", Dialog.ModalExclusionType.TOOLKIT_EXCLUDE.ordinal());
    }
}

