/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.impl.remoteskin.client.swing.util.CUtilSize;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingJComponent;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.ENotification;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.util.CUtilDouble;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.swing.CIntegerToStringMap;
import de.sillysky.nyssr.util.swing.CLowerStringMap;
import java.awt.Component;
import javax.swing.JSplitPane;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingSplitPane
extends CSwingJComponent {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingSplitPane.class);
    private static final CIntegerToStringMap mOrientation = new CIntegerToStringMap("Orientation");
    private static final CLowerStringMap mPosition = new CLowerStringMap();
    private final JSplitPane mComponent = new JSplitPane();
    private Object mDividerLocation = null;

    CSwingSplitPane(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("continuousLayout", this::applyContinuousLayout);
        list.addHandler("dividerLocation", this::applyDividerLocation);
        list.addHandler("dividerSize", this::applyDividerSize);
        list.addHandler("oneTouchExpandable", this::applyOneTouchExpandable);
        list.addHandler("orientation", this::applyOrientation);
        list.addHandler("resizeWeight", this::applyResizeWeight);
    }

    @Override
    public void notifyWidget(@NotNull ENotification aNotification, Object ... aObjects) {
        if (aNotification == ENotification.SHOWN && this.mDividerLocation != null) {
            this.applyDividerLocation(this.mDividerLocation);
        }
        super.notifyWidget(aNotification, aObjects);
    }

    @Override
    public void addChildComponent(@NotNull CWidget aChild) {
        JSplitPane pane = this.getComponent();
        Component child = aChild.getComponent();
        CUtilCheck.checkNotNull((Object)child, (String)"Child is null", (Object[])new Object[0]);
        String s = (String)aChild.getProperties().get("splitPanePosition");
        if (s != null) {
            String key = s.toLowerCase();
            if (mPosition.contains(key)) {
                pane.add(child, key);
            } else {
                LOG.error("Unknown position {}", new Object[]{key});
            }
        } else {
            LOG.error("Missing constraint position");
        }
    }

    private boolean applyDividerLocation(@NotNull String aKey, @Nullable Object aValue) {
        this.mDividerLocation = aValue;
        return true;
    }

    private boolean applyContinuousLayout(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            JSplitPane pane = this.getComponent();
            boolean b = (Boolean)aValue;
            pane.setContinuousLayout(b);
            return true;
        }
        return false;
    }

    private void applyDividerLocation(@NotNull Object aValue) {
        int location;
        JSplitPane pane = this.getComponent();
        if (aValue instanceof String && (location = CUtilSize.calcWidth(this, (String)aValue)) > 0) {
            pane.setDividerLocation(location);
        }
    }

    private boolean applyDividerSize(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            JSplitPane pane = this.getComponent();
            int size = CUtilInteger.fromObject((Object)aValue, (int)-1);
            if (size >= 0) {
                pane.setDividerSize(size);
                return true;
            }
        }
        return false;
    }

    private boolean applyOneTouchExpandable(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            JSplitPane pane = this.getComponent();
            boolean b = (Boolean)aValue;
            pane.setOneTouchExpandable(b);
            return true;
        }
        return false;
    }

    private boolean applyOrientation(@NotNull String aKey, @Nullable Object aValue) {
        JSplitPane pane = this.getComponent();
        if (aValue instanceof String) {
            int orientation = mOrientation.get((String)aValue, 1);
            pane.setOrientation(orientation);
            return true;
        }
        return false;
    }

    private boolean applyResizeWeight(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Number) {
            JSplitPane pane = this.getComponent();
            double v = CUtilDouble.fromObject((Object)aValue, (double)0.5);
            pane.setResizeWeight(v);
            return true;
        }
        return false;
    }

    @NotNull
    public JSplitPane getComponent() {
        return this.mComponent;
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.SplitPane.name();
    }

    static {
        mOrientation.add("horizontal", 1);
        mOrientation.add("vertical", 0);
        mPosition.add("left");
        mPosition.add("right");
        mPosition.add("bottom");
        mPosition.add("top");
    }
}

