/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.widget;

import de.sillysky.nyssr.impl.remoteskin.client.swing.util.CUtilToolset;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.CSwingFrame;
import de.sillysky.nyssr.impl.remoteskin.client.swing.widget.menu.CSwingMenuBar;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.remoteskin.model.CAttributeHandlerList;
import de.sillysky.nyssr.remoteskin.model.CWidget;
import de.sillysky.nyssr.remoteskin.model.CWidgetSet;
import de.sillysky.nyssr.remoteskin.model.EWidgetTypes;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.swing.CIntegerToStringMap;
import java.awt.Container;
import java.awt.Rectangle;
import javax.swing.JFrame;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CSwingJFrame
extends CSwingFrame {
    private static final ILogger LOG = CLoggerFactory.getLogger(CSwingJFrame.class);
    private static final CIntegerToStringMap mDefaultCloseOperations = new CIntegerToStringMap("DefaultCloseOperation");
    private final JFrame mComponent = new JFrame();

    CSwingJFrame(@NotNull CWidgetSet aWidgetSet, @NotNull String aId, @NotNull CJsonObject aAttributes) {
        super(aWidgetSet, aId);
        CAttributeHandlerList list = this.getAttributeHandlerList();
        list.addHandler("defaultCloseOperation", this::applyDefaultCloseOperation);
        list.addHandler("iconified", this::applyIconified);
        list.addHandler("maximized", this::applyMaximized);
        list.addHandler("maximizedHorizontal", this::applyMaximizedHorizontal);
        list.addHandler("maximizeToScreen", this::applyMaximizeToScreen);
        list.addHandler("maximizedVertical", this::applyMaximizedVertical);
    }

    @Override
    public void addChildComponent(@NotNull CWidget aChild) {
        if (aChild instanceof CSwingMenuBar) {
            JFrame frame = this.getComponent();
            CSwingMenuBar mb = (CSwingMenuBar)aChild;
            frame.setJMenuBar(mb.getComponent());
        } else {
            super.addChildComponent(aChild);
        }
    }

    private boolean applyDefaultCloseOperation(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof String) {
            JFrame frame = this.getComponent();
            String s = CUtilString.fromObject((Object)aValue, null);
            if (s != null) {
                int action = mDefaultCloseOperations.get(s, 3);
                LOG.debug("Set DefaultCloseOperation to {}", new Object[]{action});
                frame.setDefaultCloseOperation(action);
                return true;
            }
        }
        return false;
    }

    private boolean applyIconified(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            boolean b = (Boolean)aValue;
            JFrame frame = this.getComponent();
            this.setExtendedState(frame, 1, b, "ICONIFIED");
            return true;
        }
        return false;
    }

    private boolean applyMaximizeToScreen(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            JFrame frame = this.getComponent();
            boolean b = (Boolean)aValue;
            if (b) {
                Rectangle boundsFor = CUtilToolset.getScreenBoundsFor(frame.getBounds());
                frame.setBounds(boundsFor);
            }
            return true;
        }
        return false;
    }

    private boolean applyMaximized(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            JFrame frame = this.getComponent();
            boolean b = (Boolean)aValue;
            this.setExtendedState(frame, 6, b, "MAXIMIZED_BOTH");
            return true;
        }
        return false;
    }

    private boolean applyMaximizedHorizontal(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            JFrame frame = this.getComponent();
            boolean b = (Boolean)aValue;
            this.setExtendedState(frame, 2, b, "MAXIMIZED_HORIZ");
            return true;
        }
        return false;
    }

    private boolean applyMaximizedVertical(@NotNull String aKey, @Nullable Object aValue) {
        if (aValue instanceof Boolean) {
            JFrame frame = this.getComponent();
            boolean b = (Boolean)aValue;
            this.setExtendedState(frame, 4, b, "MAXIMIZED_VERT");
            return true;
        }
        return false;
    }

    @Override
    @NotNull
    public JFrame getComponent() {
        return this.mComponent;
    }

    @Override
    @Nullable
    public Container getContentPane() {
        return this.mComponent.getContentPane();
    }

    @Override
    @NotNull
    public String getWidgetType() {
        return EWidgetTypes.Frame.name();
    }

    private void setExtendedState(JFrame aFrame, int aBit, boolean aSet, String aName) {
        LOG.error("Set JFrame Extended State {}: {}", new Object[]{aName, aSet});
        int state = aFrame.getExtendedState();
        state = aSet ? (state |= aBit) : (state &= ~aBit);
        aFrame.setExtendedState(state);
    }

    static {
        mDefaultCloseOperations.add("hide", 1);
        mDefaultCloseOperations.add("exit", 3);
        mDefaultCloseOperations.add("dispose", 2);
        mDefaultCloseOperations.add("nothing", 0);
    }
}

