/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.remoteskin.client.swing.uivars;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.file.store.api.EFileDeliveryType;
import de.sillysky.nyssr.file.store.records.CRecordFileStoreRequestFile;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.remoteskin.client.swing.uivars.IUiVarHandler;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.namespace.INamespace;
import de.sillysky.nyssr.namespace.INamespaceFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.remoteskin.model.events.CEventColor;
import de.sillysky.nyssr.remoteskin.model.events.CEventDimension;
import de.sillysky.nyssr.remoteskin.model.events.CEventFont;
import de.sillysky.nyssr.remoteskin.model.events.CEventIcon;
import de.sillysky.nyssr.remoteskin.model.events.CEventMargin;
import de.sillysky.nyssr.remoteskin.model.vars.IGlobalPropertyHolder;
import de.sillysky.nyssr.remoteskin.model.vars.IGlobalPropertyListener;
import de.sillysky.nyssr.result.CResult;
import de.sillysky.nyssr.service.IService;
import de.sillysky.nyssr.service.IServiceRegistry;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilBoolean;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilUuid;
import de.sillysky.nyssr.util.key.CUtilNormalize;
import java.awt.Dimension;
import java.awt.Insets;
import java.util.HashMap;
import java.util.Map;
import java.util.UUID;
import javax.swing.Icon;
import javax.swing.ImageIcon;
import javax.swing.UIManager;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CGlobalVarListener
extends CTarget
implements IService,
IGlobalPropertyListener {
    private static final ILogger LOG = CLoggerFactory.getLogger(CGlobalVarListener.class);
    private static final int INVALID = -736573465;
    private static final String[] COLORS = new String[]{"button.background", "button.darkshadow", "button.foreground", "button.highlight", "button.light", "button.shadow", "checkbox.background", "checkbox.foreground", "checkboxmenuitem.acceleratorforeground", "checkboxmenuitem.acceleratorselectionforeground", "checkboxmenuitem.background", "checkboxmenuitem.disabledforeground", "checkboxmenuitem.foreground", "checkboxmenuitem.selectionbackground", "checkboxmenuitem.selectionforeground", "colorchooser.background", "colorchooser.foreground", "colorchooser.swatchesdefaultrecentcolor", "combobox.background", "combobox.buttonbackground", "combobox.buttondarkshadow", "combobox.buttonhighlight", "combobox.buttonshadow", "combobox.disabledbackground", "combobox.disabledforeground", "combobox.foreground", "combobox.selectionbackground", "combobox.selectionforeground", "desktop.background", "editorpane.background", "editorpane.caretforeground", "editorpane.foreground", "editorpane.inactiveforeground", "editorpane.selectionbackground", "editorpane.selectionforeground", "formattedtextfield.background", "formattedtextfield.caretforeground", "formattedtextfield.foreground", "formattedtextfield.inactivebackground", "formattedtextfield.inactiveforeground", "formattedtextfield.selectionbackground", "formattedtextfield.selectionforeground", "internalframe.activetitlebackground", "internalframe.activetitleforeground", "internalframe.bordercolor", "internalframe.borderdarkshadow", "internalframe.borderhighlight", "internalframe.borderlight", "internalframe.bordershadow", "internalframe.inactivetitlebackground", "internalframe.inactivetitleforeground", "label.background", "label.disabledforeground", "label.disabledshadow", "label.foreground", "list.background", "list.foreground", "list.selectionbackground", "list.selectionforeground", "menu.acceleratorforeground", "menu.acceleratorselectionforeground", "menu.background", "menu.disabledforeground", "menu.foreground", "menu.selectionbackground", "menu.selectionforeground", "menubar.background", "menubar.foreground", "menubar.highlight", "menubar.shadow", "menuitem.acceleratorforeground", "menuitem.acceleratorselectionforeground", "menuitem.background", "menuitem.disabledforeground", "menuitem.foreground", "menuitem.selectionbackground", "menuitem.selectionforeground", "optionpane.background", "optionpane.foreground", "optionpane.messageforeground", "panel.background", "panel.foreground", "passwordfield.background", "passwordfield.caretforeground", "passwordfield.foreground", "passwordfield.inactivebackground", "passwordfield.inactiveforeground", "passwordfield.selectionbackground", "passwordfield.selectionforeground", "popupmenu.background", "popupmenu.foreground", "progressbar.background", "progressbar.foreground", "progressbar.selectionbackground", "progressbar.selectionforeground", "radiobutton.background", "radiobutton.darkshadow", "radiobutton.foreground", "radiobutton.highlight", "radiobutton.light", "radiobutton.shadow", "radiobuttonmenuitem.acceleratorforeground", "radiobuttonmenuitem.acceleratorselectionforeground", "radiobuttonmenuitem.background", "radiobuttonmenuitem.disabledforeground", "radiobuttonmenuitem.foreground", "radiobuttonmenuitem.selectionbackground", "radiobuttonmenuitem.selectionforeground", "scrollbar.background", "scrollbar.foreground", "scrollbar.thumb", "scrollbar.thumbdarkshadow", "scrollbar.thumbhighlight", "scrollbar.thumbshadow", "scrollbar.track", "scrollbar.trackhighlight", "scrollpane.background", "scrollpane.foreground", "separator.background", "separator.foreground", "separator.highlight", "separator.shadow", "slider.background", "slider.focus", "slider.foreground", "slider.highlight", "slider.shadow", "spinner.background", "spinner.foreground", "splitpane.background", "splitpane.darkshadow", "splitpane.highlight", "splitpane.shadow", "tabbedpane.background", "tabbedpane.darkshadow", "tabbedpane.focus", "tabbedpane.foreground", "tabbedpane.highlight", "tabbedpane.light", "tabbedpane.selected", "tabbedpane.shadow", "table.background", "table.focuscellbackground", "table.focuscellforeground", "table.foreground", "table.gridcolor", "table.selectionbackground", "table.selectionforeground", "tableheader.background", "tableheader.foreground", "textarea.background", "textarea.caretforeground", "textarea.foreground", "textarea.inactiveforeground", "textarea.selectionbackground", "textarea.selectionforeground", "textfield.background", "textfield.caretforeground", "textfield.darkshadow", "textfield.foreground", "textfield.highlight", "textfield.inactivebackground", "textfield.inactiveforeground", "textfield.light", "textfield.selectionbackground", "textfield.selectionforeground", "textfield.shadow", "textpane.background", "textpane.caretforeground", "textpane.foreground", "textpane.inactiveforeground", "textpane.selectionbackground", "textpane.selectionforeground", "titledborder.titlecolor", "togglebutton.background", "togglebutton.darkshadow", "togglebutton.foreground", "togglebutton.highlight", "togglebutton.light", "togglebutton.shadow", "toolbar.background", "toolbar.darkshadow", "toolbar.dockingbackground", "toolbar.dockingforeground", "toolbar.floatingbackground", "toolbar.floatingforeground", "toolbar.foreground", "toolbar.highlight", "toolbar.light", "toolbar.shadow", "tooltip.background", "tooltip.foreground", "tree.background", "tree.foreground", "tree.hash", "tree.selectionbackground", "tree.selectionbordercolor", "tree.selectionforeground", "tree.textbackground", "tree.textforeground", "viewport.background", "viewport.foreground"};
    private static final String[] FONTS = new String[]{"button.font", "checkbox.font", "checkboxmenuitem.acceleratorfont", "checkboxmenuitem.font", "colorchooser.font", "combobox.font", "editorpane.font", "formattedtextfield.font", "internalframe.titlefont", "label.font", "list.font", "menu.acceleratorfont", "menu.font", "menubar.font", "menuitem.acceleratorfont", "menuitem.font", "optionpane.font", "panel.font", "passwordfield.font", "popupmenu.font", "progressbar.font", "radiobutton.font", "radiobuttonmenuitem.acceleratorfont", "radiobuttonmenuitem.font", "scrollpane.font", "spinner.font", "tabbedpane.font", "table.font", "tableheader.font", "textarea.font", "textfield.font", "textpane.font", "titledborder.font", "togglebutton.font", "toolbar.font", "tooltip.font", "tree.font", "viewport.font"};
    private static final String[] INSETS = new String[]{"button.margin", "checkbox.margin", "checkboxmenuitem.margin", "editorpane.margin", "formattedtextfield.margin", "menu.margin", "menuitem.margin", "passwordfield.margin", "radiobutton.margin", "radiobuttonmenuitem.margin", "slider.focusinsets", "tabbedpane.contentborderinsets", "tabbedpane.selectedtabpadinsets", "tabbedpane.tabareainsets", "tabbedpane.tabinsets", "textarea.margin", "textfield.margin", "textpane.margin", "togglebutton.margin"};
    private static final String[] INTEGERS = new String[]{"button.texticongap", "button.textshiftoffset", "checkbox.texticongap", "checkbox.textshiftoffset", "colorchooser.rgbredmnemonic", "colorchooser.rgbgreenmnemonic", "colorchooser.rgbbluemnemonic", "editorpane.caretblinkrate", "filechooser.cancelbuttonmnemonic", "filechooser.directoryopenbuttonmnemonic", "filechooser.helpbuttonmnemonic", "filechooser.openbuttonmnemonic", "filechooser.savebuttonmnemonic", "filechooser.updatebuttonmnemonic", "formattedtextfield.caretblinkrate", "menu.menupopupoffsetx", "menu.menupopupoffsety", "menu.submenupopupoffsetx", "menu.submenupopupoffsety", "optionpane.buttonclickthreshold", "passwordfield.caretblinkrate", "progressbar.celllength", "progressbar.cellspacing", "progressbar.cycletime", "progressbar.repaintinterval", "radiobutton.texticongap", "radiobutton.textshiftoffset", "scrollbar.width", "splitpane.dividersize", "tabbedpane.tabrunoverlay", "tabbedpane.texticongap", "textarea.caretblinkrate", "textfield.caretblinkrate", "textpane.caretblinkrate", "togglebutton.texticongap", "togglebutton.textshiftoffset", "tree.leftchildindent", "tree.rightchildindent", "tree.rowheight"};
    private static final String[] DIMENSIONS = new String[]{"colorchooser.swatchesrecentswatchsize", "colorchooser.swatchesswatchsize", "optionpane.minimumsize", "scrollbar.maximumthumbsize", "scrollbar.minimumthumbsize", "spinner.arrowbuttonsize", "toolbar.separatorsize"};
    private static final String[] ICONS = new String[]{"checkbox.icon", "checkboxmenuitem.arrowicon", "checkboxmenuitem.checkicon", "filechooser.detailsviewicon", "filechooser.homefoldericon", "filechooser.listviewicon", "filechooser.newfoldericon", "filechooser.upfoldericon", "fileview.computericon", "fileview.directoryicon", "fileview.fileicon", "fileview.floppydriveicon", "fileview.harddriveicon", "internalframe.closeicon", "internalframe.icon", "internalframe.iconifyicon", "internalframe.maximizeicon", "internalframe.minimizeicon", "menu.arrowicon", "menu.checkicon", "menuitem.arrowicon", "menuitem.checkicon", "optionpane.erroricon", "optionpane.informationicon", "optionpane.questionicon", "optionpane.warningicon", "radiobutton.icon", "radiobuttonmenuitem.arrowicon", "radiobuttonmenuitem.checkicon", "tree.closedicon", "tree.collapsedicon", "tree.expandedicon", "tree.leaficon", "tree.openicon"};
    private static final String[] INPUT_MAPS = new String[]{"button.focusinputmap", "checkbox.focusinputmap", "combobox.ancestorinputmap", "desktop.ancestorinputmap", "filechooser.ancestorinputmap", "formattedtextfield.focusinputmap", "list.focusinputmap", "list.focusinputmap.righttoleft", "radiobutton.focusinputmap", "scrollbar.focusinputmap", "scrollbar.focusinputmap.righttoleft", "scrollpane.ancestorinputmap", "slider.focusinputmap", "slider.focusinputmap.righttoleft", "spinner.ancestorinputmap", "splitpane.ancestorinputmap", "tabbedpane.ancestorinputmap", "tabbedpane.focusinputmap", "table.ancestorinputmap", "table.ancestorinputmap.righttoleft", "togglebutton.focusinputmap", "toolbar.ancestorinputmap", "tree.ancestorinputmap", "tree.focusinputmap", "tree.focusinputmap.righttoleft"};
    private static final String[] NULLS = new String[]{"checkboxmenuitem.commandsound", "internalframe.closesound", "internalframe.maximizesound", "internalframe.minimizesound", "internalframe.restoredownsound", "internalframe.restoreupsound", "menuitem.commandsound", "optionpane.errorsound", "optionpane.informationsound", "optionpane.questionsound", "optionpane.warningsound", "popupmenu.popupsound", "radiobuttonmenuitem.commandsound", "auditorycues.playlist"};
    private static final String[] STRINGS = new String[]{"menuitem.acceleratordelimiter"};
    private static final String[] BORDERS = new String[]{"button.border", "checkbox.border", "checkboxmenuitem.border", "colorchooser.selectedcolorborder", "desktopicon.border", "editorpane.border", "formattedtextfield.border", "internalframe.border", "label.border", "list.border", "list.focuscellhighlightborder", "menu.border", "menubar.border", "menuitem.border", "optionpane.border", "optionpane.buttonareaborder", "optionpane.messageareaborder", "passwordfield.border", "popupmenu.border", "progressbar.border", "radiobutton.border", "radiobuttonmenuitem.border", "scrollbar.border", "scrollpane.border", "scrollpane.viewportborder", "slider.border", "spinner.border", "splitpane.border", "splitpanedivider.border", "table.focuscellhighlightborder", "table.scrollpaneborder", "tableheader.cellborder", "textarea.border", "textfield.border", "textpane.border", "titledborder.border", "togglebutton.border", "toolbar.border", "tooltip.border", "tree.editorborder"};
    private static final String[] BOOLEANS = new String[]{"checkboxmenuitem.borderpainted", "menu.borderpainted", "menuitem.borderpainted", "radiobuttonmenuitem.borderpainted", "tree.changeselectionwithfocus", "tree.drawsfocusborderaroundicon", "tree.scrollsonexpand"};
    private final Map<String, IUiVarHandler> mVars = new HashMap<String, IUiVarHandler>();
    private final Map<UUID, String> mPendingIconRequests = new HashMap<UUID, String>();

    CGlobalVarListener() {
    }

    public void activate(@NotNull IServiceRegistry aServiceRegistry) throws CException {
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordFileStoreRequestFile.ID, this::asyncLfsGetFile);
        for (String color : COLORS) {
            this.mVars.put(color, this::handleColor);
        }
        for (String bool : BOOLEANS) {
            this.mVars.put(bool, this::handleBoolean);
        }
        for (String key : STRINGS) {
            this.mVars.put(key, this::handleString);
        }
        for (String key : DIMENSIONS) {
            this.mVars.put(key, this::handleDimension);
        }
        for (String key : INSETS) {
            this.mVars.put(key, this::handleInset);
        }
        for (String key : NULLS) {
            this.mVars.put(key, this::handleNull);
        }
        for (String key : INTEGERS) {
            this.mVars.put(key, this::handleInteger);
        }
        for (String key : ICONS) {
            this.mVars.put(key, this::handleIcon);
        }
        for (String key : FONTS) {
            this.mVars.put(key, this::handleFont);
        }
        for (String key : INPUT_MAPS) {
            this.mVars.put(key, this::handleInputMap);
        }
        for (String key : BORDERS) {
            this.mVars.put(key, this::handleBorder);
        }
        IGlobalPropertyHolder service = (IGlobalPropertyHolder)aServiceRegistry.getService(IGlobalPropertyHolder.class);
        if (service != null) {
            service.addListener((IGlobalPropertyListener)this);
        }
        INamespaceFactory nsf = (INamespaceFactory)aServiceRegistry.getServiceOrThrow(INamespaceFactory.class);
        INamespace namespace = nsf.getNamespace(CWellKnownNID.SYSTEM);
        namespace.getTargetRegistry().registerTarget((ITarget)this);
    }

    private void requestIcon(@NotNull String aPath, @NotNull String aKey) throws CException {
        CEnvelope env = CEnvelope.forLocalNanoService((IId)CWellKnownNID.SYSTEM);
        UUID transactionId = CUtilUuid.random();
        this.mPendingIconRequests.put(transactionId, aKey);
        env.setTransactionId(transactionId);
        CRecord record = CRecordFileStoreRequestFile.create();
        CRecordFileStoreRequestFile.setPath((CRecord)record, (String)aPath);
        CRecordFileStoreRequestFile.setDeliveryType((CRecord)record, (byte)EFileDeliveryType.BYTES.getType());
        this.sendRequest(env, record);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        return true;
    }

    private boolean asyncLfsGetFile(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            CResult result = aEnvelope.getResult();
            if (result.isSuccess()) {
                UUID transactionId = aEnvelope.getTransactionId();
                String key = this.mPendingIconRequests.remove(transactionId);
                if (key == null) {
                    LOG.error("No IconRequestEntry found");
                } else {
                    byte[] bytes = CRecordFileStoreRequestFile.getBytes((CRecord)aRecord, null);
                    if (bytes != null) {
                        ImageIcon icon = new ImageIcon(bytes, key);
                        this.setIcon(icon, key);
                    }
                }
            }
            return true;
        }
        return false;
    }

    private void handleNull(@NotNull String aKey, @NotNull Object aValue) {
        UIManager.put(aKey, null);
    }

    private void handleColor(@NotNull String aKey, @NotNull Object aValue) {
        CEventColor dc = CEventColor.create((Object)aValue);
        if (dc != null) {
            UIManager.put(aKey, dc.createColor());
        }
    }

    private void handleBoolean(@NotNull String aKey, @NotNull Object aValue) {
        boolean b = CUtilBoolean.fromObject((Object)aValue, (boolean)false);
        UIManager.put(aKey, b);
    }

    private void handleString(@NotNull String aKey, @NotNull Object aValue) {
        String s = CUtilString.fromObject((Object)aValue, null);
        if (s != null) {
            UIManager.put(aKey, s);
        }
    }

    private void handleDimension(@NotNull String aKey, @NotNull Object aValue) {
        CEventDimension ev = CEventDimension.create((Object)aValue);
        if (ev != null) {
            Dimension dim = ev.getDimension();
            UIManager.put(aKey, dim);
        }
    }

    private void handleInset(@NotNull String aKey, @NotNull Object aValue) {
        CEventMargin event = CEventMargin.create((Object)aValue);
        if (event != null) {
            Insets insets = event.getMargin().toInsets();
            UIManager.put(aKey, insets);
        }
    }

    private void handleInteger(@NotNull String aKey, @NotNull Object aValue) {
        int value = CUtilInteger.fromObject((Object)aValue, (int)-736573465);
        if (value != -736573465) {
            UIManager.put(aKey, value);
        }
    }

    private void handleIcon(@NotNull String aKey, @NotNull Object aValue) {
        CEventIcon event = CEventIcon.fromObject((Object)aValue);
        if (event != null) {
            String path = event.getPath();
            if (CUtilString.isValid((String)path)) {
                try {
                    this.requestIcon(path, aKey);
                }
                catch (CException aE) {
                    LOG.error("Error requesting icon {}", new Object[]{path});
                }
            } else {
                ImageIcon icon = event.createIcon(((Object)((Object)this)).getClass());
                if (icon != null) {
                    this.setIcon(icon, aKey);
                }
            }
        }
    }

    private void setIcon(@NotNull Icon aIcon, @NotNull String aKey) {
        UIManager.put(aKey, aIcon);
    }

    private void handleInputMap(@NotNull String aKey, @NotNull Object aValue) {
    }

    private void handleBorder(@NotNull String aKey, @NotNull Object aValue) {
    }

    private void handleFont(@NotNull String aKey, @NotNull Object aValue) {
        CEventFont event = CEventFont.create((Object)aValue);
        if (event != null) {
            UIManager.put(aKey, event.createFont());
        }
    }

    public void deactivate(@NotNull IServiceRegistry aServiceRegistry) {
        IGlobalPropertyHolder service = (IGlobalPropertyHolder)aServiceRegistry.getService(IGlobalPropertyHolder.class);
        if (service != null) {
            service.removeListener((IGlobalPropertyListener)this);
        }
    }

    public void notifyChanged(@NotNull String aKey, @Nullable Object aValue) {
        String key = CUtilNormalize.normalize((String)aKey);
        IUiVarHandler handler = this.mVars.get(key);
        if (handler != null) {
            handler.handle(aKey, aValue);
        }
    }
}

