/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.version;

import de.sillysky.nyssr.util.files.CUtilPath;
import java.io.File;
import java.util.Arrays;
import java.util.Objects;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CVersion
implements Comparable<CVersion> {
    private static final String DELIMITER_NUMBERS = ".";
    private static final String DELIMITER_SUFFIX = "-";
    static final String MATCH1 = "(?!\\.)(\\d+(\\.\\d+)+)(?:[-.][A-Z]+)?(?![\\d.])$";
    private static final String MATCH2 = "\\.";
    private static final String MATCH3 = "-";
    private static final int MAX_VERSIONS = 3;
    private final int[] mNumbers = new int[3];
    private String mSuffix = "";
    private Object mData;

    @NotNull
    public static CVersion fromFilename(@NotNull String aFilename) {
        String suffix = "";
        String vs = "";
        int[] numbers = new int[3];
        String[] parts0 = aFilename.split("-");
        if (parts0.length == 1) {
            vs = aFilename;
            suffix = "";
        } else if (parts0.length == 2) {
            vs = parts0[1];
            suffix = "";
        } else if (parts0.length >= 2) {
            vs = parts0[parts0.length - 2];
            suffix = parts0[parts0.length - 1];
        }
        if (!vs.isEmpty()) {
            String[] parts = vs.split(MATCH2);
            for (int i = 0; i < parts.length && i < 3; ++i) {
                try {
                    numbers[i] = Integer.parseInt(parts[i]);
                    continue;
                }
                catch (NumberFormatException ignore) {
                    numbers[i] = 0;
                }
            }
        }
        return new CVersion(numbers[0], numbers[1], numbers[2], suffix);
    }

    @NotNull
    public static CVersion fromFile(@NotNull File aFile) {
        String temp = aFile.getName();
        temp = CUtilPath.stripExtension(temp);
        CVersion v = CVersion.fromFilename(temp);
        v.setData(aFile);
        return v;
    }

    public CVersion(int aVersion1, int aVersion2, int aVersion3, @NotNull String aSuffix) {
        this.mNumbers[0] = aVersion1;
        this.mNumbers[1] = aVersion2;
        this.mNumbers[2] = aVersion3;
        this.mSuffix = aSuffix;
        this.mData = null;
    }

    public int getMajorVersion() {
        return this.mNumbers[0];
    }

    public int getMinorVersion() {
        return this.mNumbers[1];
    }

    public int getPatchVersion() {
        return this.mNumbers[2];
    }

    public String getSuffix() {
        return this.mSuffix;
    }

    @Override
    public int compareTo(@Nullable CVersion aThat) {
        if (aThat == null) {
            return 1;
        }
        int result = Integer.compare(this.getMajorVersion(), aThat.getMajorVersion());
        if (result == 0 && (result = Integer.compare(this.getMinorVersion(), aThat.getMinorVersion())) == 0 && (result = Integer.compare(this.getPatchVersion(), aThat.getPatchVersion())) == 0) {
            boolean e2;
            boolean e1 = this.getSuffix().isEmpty();
            result = e1 == (e2 = aThat.getSuffix().isEmpty()) ? this.getSuffix().compareTo(aThat.getSuffix()) : (e1 ? -1 : 1);
        }
        return result;
    }

    public Object getData() {
        return this.mData;
    }

    public void setData(@Nullable Object aData) {
        this.mData = aData;
    }

    public boolean equals(Object aO) {
        if (this == aO) {
            return true;
        }
        if (aO == null || this.getClass() != aO.getClass()) {
            return false;
        }
        CVersion cVersion = (CVersion)aO;
        return Arrays.equals(this.mNumbers, cVersion.mNumbers) && this.mSuffix.equals(cVersion.mSuffix);
    }

    public int hashCode() {
        int result = Objects.hash(this.mSuffix);
        result = 31 * result + Arrays.hashCode(this.mNumbers);
        return result;
    }

    @Contract(pure=true)
    @NotNull
    public String toString() {
        return this.mNumbers[0] + DELIMITER_NUMBERS + this.mNumbers[1] + DELIMITER_NUMBERS + this.mNumbers[2] + (this.mSuffix.isEmpty() ? "" : "-" + this.mSuffix);
    }
}

