/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.swing.color;

import de.sillysky.nyssr.exception.CUtilCheck;
import java.awt.Color;
import java.util.Objects;

public final class CNamedColor {
    private final String mName;
    private final int mRed;
    private final int mGreen;
    private final int mBlue;

    public CNamedColor(int aRed, int aGreen, int aBlue) {
        this.mName = "";
        this.mRed = aRed;
        this.mGreen = aGreen;
        this.mBlue = aBlue;
    }

    public CNamedColor(String aName, int aRed, int aGreen, int aBlue) {
        this.mName = aName;
        this.mRed = aRed;
        this.mGreen = aGreen;
        this.mBlue = aBlue;
    }

    CNamedColor(String aName, String aColor) {
        this.mName = aName;
        String in = aColor.charAt(0) == '#' ? aColor.substring(1) : aColor;
        CUtilCheck.checkEqual(in.length(), 6, "Invalid length (allowed id #F0F8FF or F0F8FF)", new Object[0]);
        int[] data = new int[3];
        for (int i = 0; i < 6; i += 2) {
            data[i / 2] = (Character.digit(in.charAt(i), 16) << 4) + Character.digit(in.charAt(i + 1), 16);
        }
        this.mRed = data[0];
        this.mGreen = data[1];
        this.mBlue = data[2];
    }

    public static int getHash(int aRed, int aGreen, int aBlue) {
        return Objects.hash(aRed, aGreen, aBlue);
    }

    public int getBlue() {
        return this.mBlue;
    }

    public Color getColor(int aAlpha) {
        return new Color(this.mRed, this.mGreen, this.mBlue, aAlpha);
    }

    public int[] getRGB() {
        return new int[]{this.mRed, this.mGreen, this.mBlue};
    }

    public int getGreen() {
        return this.mGreen;
    }

    public int getHash() {
        return CNamedColor.getHash(this.mRed, this.mGreen, this.mBlue);
    }

    public String getName() {
        return this.mName;
    }

    public int getRed() {
        return this.mRed;
    }

    public String toString() {
        return this.mName;
    }
}

