/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.swing.border;

import de.sillysky.nyssr.util.swing.border.EPointerPosition;
import java.awt.BasicStroke;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Graphics;
import java.awt.Graphics2D;
import java.awt.Insets;
import java.awt.Polygon;
import java.awt.Rectangle;
import java.awt.RenderingHints;
import java.awt.geom.Area;
import java.awt.geom.RoundRectangle2D;
import javax.swing.border.AbstractBorder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CBubbleBorder
extends AbstractBorder {
    private static final int POINTER_PAD = 4;
    final RenderingHints mHints;
    private EPointerPosition mPointerPosition = EPointerPosition.none;
    private int mStrokePad;
    private Color mLineColor = Color.BLACK;
    private int mThickness = 1;
    private int mRadius = 15;
    private int mPointerSize = 0;
    private Insets mInsets = null;
    private BasicStroke mStroke = null;

    public CBubbleBorder() {
        this.mHints = new RenderingHints(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_ON);
    }

    public void setPointerPosition(EPointerPosition aPointerPosition) {
        this.mPointerPosition = aPointerPosition;
    }

    public void setRadius(int aRadius) {
        this.mRadius = aRadius;
        this.calc();
    }

    public void setPointerSize(int aPointerSize) {
        this.mPointerSize = aPointerSize;
        this.calc();
    }

    public void setThickness(int aThickness) {
        this.mThickness = aThickness;
        this.calc();
    }

    public void setLineColor(@NotNull Color aLineColor) {
        this.mLineColor = aLineColor;
    }

    @Override
    public Insets getBorderInsets(Component c) {
        return this.mInsets;
    }

    @Override
    public Insets getBorderInsets(Component c, Insets insets) {
        return this.getBorderInsets(c);
    }

    private void calc() {
        this.mStroke = new BasicStroke(this.mThickness);
        this.mStrokePad = this.mThickness / 2;
        int pad = this.mRadius + this.mStrokePad;
        int bottomPad = pad + this.mPointerSize + this.mStrokePad;
        this.mInsets = new Insets(pad, pad, bottomPad, pad);
    }

    @Override
    public void paintBorder(Component c, Graphics g, int x, int y, int width, int height) {
        Graphics2D g2 = (Graphics2D)g;
        g2.setRenderingHints(this.mHints);
        int bottomLineY = height - this.mThickness - this.mPointerSize;
        RoundRectangle2D.Double bubble = new RoundRectangle2D.Double(this.mStrokePad, this.mStrokePad, width - this.mThickness, bottomLineY, this.mRadius, this.mRadius);
        Polygon pointer = new Polygon();
        if (this.mPointerPosition == EPointerPosition.left) {
            pointer.addPoint(this.mStrokePad + this.mRadius + 4, bottomLineY);
            pointer.addPoint(this.mStrokePad + this.mRadius + 4 + this.mPointerSize, bottomLineY);
            pointer.addPoint(this.mStrokePad + this.mRadius + 4 + this.mPointerSize / 2, height - this.mStrokePad);
        } else if (this.mPointerPosition == EPointerPosition.right) {
            pointer.addPoint(width - (this.mStrokePad + this.mRadius + 4), bottomLineY);
            pointer.addPoint(width - (this.mStrokePad + this.mRadius + 4 + this.mPointerSize), bottomLineY);
            pointer.addPoint(width - (this.mStrokePad + this.mRadius + 4 + this.mPointerSize / 2), height - this.mStrokePad);
        }
        Area area = new Area(bubble);
        area.add(new Area(pointer));
        Color bg = this.getParentBackground(c);
        if (bg != null) {
            Rectangle rect = new Rectangle(0, 0, width, height);
            Area borderRegion = new Area(rect);
            borderRegion.subtract(area);
            g2.setClip(borderRegion);
            g2.setColor(bg);
            g2.fillRect(0, 0, width, height);
            g2.setClip(null);
        }
        if (this.mThickness > 0) {
            g2.setColor(this.mLineColor);
            g2.setStroke(this.mStroke);
            g2.draw(area);
        }
    }

    @Nullable
    private Color getParentBackground(@NotNull Component aComponent) {
        for (Container parent = aComponent.getParent(); parent != null; parent = parent.getParent()) {
            if (!parent.isOpaque()) continue;
            return parent.getBackground();
        }
        return null;
    }
}

