/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.properties.hierarchical;

import de.sillysky.nyssr.util.properties.hierarchical.CHierarchicalProperty;
import de.sillysky.nyssr.util.properties.hierarchical.IHierarchicalPropertyParser;
import java.util.HashMap;
import java.util.Map;
import org.jetbrains.annotations.NotNull;

public class CHierarchicalPropertyParserRegistry {
    private final Map<String, IHierarchicalPropertyParser> mParsers = new HashMap<String, IHierarchicalPropertyParser>();

    public IHierarchicalPropertyParser deregisterParser(@NotNull String aKey) {
        return this.mParsers.remove(aKey);
    }

    public void parse(@NotNull CHierarchicalProperty aProperty, @NotNull String aString) {
        IHierarchicalPropertyParser parser = this.mParsers.get(aProperty.getKey());
        if (parser != null) {
            parser.parse(aProperty, aString);
        }
    }

    public CHierarchicalProperty parse(@NotNull String aKey, @NotNull String aString) {
        CHierarchicalProperty result = null;
        IHierarchicalPropertyParser parser = this.mParsers.get(aKey);
        if (parser != null) {
            result = new CHierarchicalProperty(aKey);
            parser.parse(result, aString);
        }
        return result;
    }

    public IHierarchicalPropertyParser registerParser(@NotNull String aKey, @NotNull IHierarchicalPropertyParser aParser) {
        return this.mParsers.put(aKey, aParser);
    }
}

