/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.properties;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.file.Files;
import java.nio.file.OpenOption;
import java.nio.file.Path;
import java.util.Map;
import java.util.Properties;
import org.jetbrains.annotations.NotNull;

public final class CUtilPropertyReader {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilPropertyReader.class);
    private static final String EXT = ".cfg";

    private CUtilPropertyReader() {
    }

    @NotNull
    public static Properties readFile(@NotNull File aFile) {
        Properties prop = new Properties();
        if (!aFile.exists()) {
            LOG.info("No property file found: {}", aFile);
            return prop;
        }
        LOG.info("Read property file: {}", aFile);
        try (InputStream input = Files.newInputStream(aFile.toPath(), new OpenOption[0]);){
            prop.load(input);
        }
        catch (IOException ex) {
            LOG.error("Error reading the property file {}", aFile, ex);
        }
        return prop;
    }

    @NotNull
    public static CStringProperties readStringProperties(@NotNull Path aDir, @NotNull String aFile) {
        CStringProperties result = new CStringProperties();
        Path dir = aDir.resolve(aFile + EXT);
        File f = dir.toFile();
        Properties properties = CUtilPropertyReader.readFile(f);
        CUtilPropertyReader.propertiesToStringProperties(properties, result);
        return result;
    }

    @NotNull
    public static CStringProperties readStringProperties(@NotNull File aFile) {
        CStringProperties result = new CStringProperties();
        Properties properties = CUtilPropertyReader.readFile(aFile);
        CUtilPropertyReader.propertiesToStringProperties(properties, result);
        return result;
    }

    public static void propertiesToStringProperties(@NotNull Properties aSrc, @NotNull CStringProperties aDest) {
        for (Map.Entry<Object, Object> e : aSrc.entrySet()) {
            String key = e.getKey().toString();
            String value = e.getValue().toString();
            aDest.put(key, value);
        }
    }
}

