/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.cmdline;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.util.cmdline.CCommandLineOption;
import de.sillysky.nyssr.util.cmdline.CFoundOption;
import de.sillysky.nyssr.util.cmdline.CFoundOptionList;
import java.util.ArrayList;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CCommandLineParser {
    private final List<CCommandLineOption> mOptions = new ArrayList<CCommandLineOption>();

    public void addOption(@NotNull CCommandLineOption aOption) {
        this.mOptions.add(aOption);
    }

    @Nullable
    private CCommandLineOption getOption(@NotNull String aToken) {
        if (aToken.startsWith("-")) {
            return this.mOptions.stream().filter(option -> option.getName().equals(aToken.substring(1))).findFirst().orElse(null);
        }
        return null;
    }

    public CFoundOptionList parseCommandLine(@NotNull String aCmdLine) throws CException {
        String[] tokens = aCmdLine.split(" ");
        return this.parseCommandLine(tokens);
    }

    private boolean isOption(@NotNull String aToken) {
        return aToken.startsWith("-");
    }

    private void handleOption(@NotNull CCommandLineOption aLastOption, @NotNull List<String> aArguments) {
    }

    public CFoundOptionList parseCommandLine(@NotNull @NotNull String @NotNull [] aTokens) throws CException {
        CFoundOptionList found = new CFoundOptionList();
        ArrayList<String> arguments = new ArrayList<String>();
        CCommandLineOption lastOption = null;
        for (String token : aTokens) {
            if (this.isOption(token)) {
                if (lastOption != null) {
                    CFoundOption foundOption = new CFoundOption(lastOption, arguments);
                    found.addFoundOption(foundOption);
                    arguments.clear();
                }
                if ((lastOption = this.getOption(token)) != null) continue;
                throw new CException(5701).append("Unknown Token: ").append(token);
            }
            arguments.add(token);
        }
        if (lastOption != null) {
            CFoundOption foundOption = new CFoundOption(lastOption, arguments);
            found.addFoundOption(foundOption);
            arguments.clear();
        }
        return found;
    }
}

