/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilInteger;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.array.CUtilArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilIntegerArray {
    public static final int[] EMPTY = new int[0];
    private static final int ITEM_STRING_LENGTH = 6;

    private CUtilIntegerArray() {
    }

    public static int @Nullable [] copy(int @Nullable [] aValue) {
        if (aValue == null) {
            return null;
        }
        if (aValue.length == 0) {
            return EMPTY;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }

    public static int @NotNull [] fromList(@Nullable List<?> aValue) {
        if (aValue == null || aValue.isEmpty()) {
            return EMPTY;
        }
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (Object element : aValue) {
            int[] nArray;
            if (element == null) continue;
            if (element instanceof Integer) {
                Integer e = (Integer)element;
                list.add(e);
                continue;
            }
            if (element instanceof Integer[]) {
                Integer[] ee2 = (Integer[])element;
                Collections.addAll(list, ee2);
                continue;
            }
            if (element instanceof int[]) {
                int[] ee;
                for (int e : ee = (int[])element) {
                    list.add(e);
                }
                continue;
            }
            if (!(element instanceof String)) continue;
            String s = (String)element;
            for (int e : nArray = CUtilIntegerArray.fromString(s)) {
                list.add(e);
            }
        }
        int[] arr = new int[list.size()];
        int pos = 0;
        for (Integer n : list) {
            arr[pos] = n;
            ++pos;
        }
        return arr;
    }

    @Contract(pure=true)
    public static int @NotNull [] fromIntegerCollection(@NotNull Collection<Integer> aList) {
        int[] result = new int[aList.size()];
        int i = 0;
        for (Integer o : aList) {
            result[i] = o == null ? 0 : o;
            ++i;
        }
        return result;
    }

    public static int @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        int[] array = new int[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            array[i] = CUtilInteger.fromStream(aStream);
        }
        return array;
    }

    public static int @NotNull [] random(int aLength) {
        int[] array = new int[aLength];
        for (int i = 0; i < aLength; ++i) {
            array[i] = CUtilRandom.getRandom().nextInt();
        }
        return array;
    }

    public static int @NotNull [] fromString(@Nullable String aValue) {
        return CUtilIntegerArray.fromString(aValue, ",");
    }

    public static int @NotNull [] fromString(@Nullable String aValue, @NotNull String aDelimiter) {
        int[] arr;
        if (aValue == null || aValue.isEmpty()) {
            arr = new int[]{};
        } else {
            String[] tokens = aValue.split(aDelimiter, -1);
            arr = new int[tokens.length];
            for (int i = 0; i < tokens.length; ++i) {
                arr[i] = CUtilInteger.fromString(tokens[i]);
            }
        }
        return arr;
    }

    public static boolean isEqual(int @Nullable [] aValue1, int @Nullable [] aValue2) {
        return Arrays.equals(aValue1, aValue2);
    }

    @NotNull
    public static String toString(int @Nullable [] aValue, char aDelimiter, int aMaxLen) {
        if (aValue == null) {
            return "null";
        }
        return CUtilArray.toString(0, aDelimiter, aMaxLen, index -> index >= aValue.length ? "\uf00bE" : Integer.toString(aValue[index]));
    }

    public static void toStream(@NotNull DataOutput aStream, int @Nullable [] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (int element : aValue) {
                aStream.writeInt(element);
            }
        }
    }
}

