/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.test;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.test.ITest;
import de.sillysky.nyssr.test.ITestRunner;
import java.util.UUID;

public abstract class CAbstractTest
extends CTarget
implements ITest {
    private static final ILogger LOG = CLoggerFactory.getLogger("test");
    private UUID mTestId;
    private boolean mRunning = false;
    private ITestRunner mTestRunner;
    private long mStartTime;
    private long mLoops;

    protected CAbstractTest() {
    }

    protected abstract void cleanUp() throws Exception;

    public void deactivate() {
        if (this.mTestRunner != null) {
            try {
                this.mTestRunner.deregisterTest(this);
            }
            catch (CException e) {
                LOG.error((Throwable)e, "Error deregister Test");
            }
        }
    }

    protected void finish(int aResultCode, long aLoops) throws Exception {
        long nanos = System.nanoTime() - this.mStartTime;
        this.mTestRunner.finished(this.mTestId, aResultCode, aLoops, nanos);
        this.mRunning = false;
        this.mTestId = null;
        this.cleanUp();
    }

    protected long getLoopsToPerform() {
        return this.mLoops;
    }

    protected long getStartTime() {
        return this.mStartTime;
    }

    protected UUID getTestID() {
        return this.mTestId;
    }

    protected ITestRunner getTestRunner() {
        return this.mTestRunner;
    }

    protected boolean isRunning() {
        return this.mRunning;
    }

    protected void setTestRunner(ITestRunner aTestRunner) {
        this.mTestRunner = aTestRunner;
        try {
            this.mTestRunner.registerTest(this);
        }
        catch (CException e) {
            LOG.error((Throwable)e, "Error register test");
        }
    }

    @Override
    public void startTest(UUID aTestRunID, ITestRunner aTester, long aLoops) throws Exception {
        if (this.mRunning) {
            throw new CException(4).append("Already Running");
        }
        this.mTestRunner = aTester;
        this.mTestId = aTestRunID;
        this.mRunning = true;
        this.mLoops = aLoops;
        this.mStartTime = System.nanoTime();
        LOG.info("Start Test {}: {}", this.getTestName(), this.getTestSuite());
        this.testStarted();
    }

    protected abstract void testStarted() throws Exception;

    @Override
    public String toString() {
        return this.getTestSuite() + '#' + this.getTestName();
    }
}

