/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.log.catcher.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.properties.CStringProperties;
import org.jetbrains.annotations.NotNull;

public final class CRecordLog
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("7b139e71-a955-4e2a-b3d1-db4ab806479f");
    public static final String NAME = "Log";
    public static final String DESCRIPTION = "A new log entry.";
    public static final String SLOT_CLASS = "C";
    public static final String SLOT_FILE = "A";
    public static final String SLOT_FORMATTED_MESSAGE = "1";
    public static final String SLOT_IS_NATIVE_METHOD = "E";
    public static final String SLOT_LEVEL = "2";
    public static final String SLOT_LINE = "B";
    public static final String SLOT_LOGGER_NAME = "3";
    public static final String SLOT_MESSAGE = "4";
    public static final String SLOT_METHOD = "D";
    public static final String SLOT_PROPERTIES = "9";
    public static final String SLOT_THREAD_ID = "6";
    public static final String SLOT_THREAD_NAME = "5";
    public static final String SLOT_THREAD_PRIORITY = "7";
    public static final String SLOT_TIME_STAMP = "8";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String getClass(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_CLASS);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getFile(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FILE);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getFormattedMessage(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_FORMATTED_MESSAGE);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static boolean getIsNativeMethod(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_IS_NATIVE_METHOD);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static String getLevel(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LEVEL);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getLine(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LINE);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getLoggerName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LOGGER_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getMessage(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MESSAGE);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getMethod(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_METHOD);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static CStringProperties getProperties(@NotNull CRecord aRecord, CStringProperties aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_PROPERTIES);
        if (slot == null) {
            return aDefault;
        }
        return (CStringProperties)slot.getValue();
    }

    public static String getThreadId(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_THREAD_ID);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static String getThreadName(@NotNull CRecord aRecord, String aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_THREAD_NAME);
        if (slot == null) {
            return aDefault;
        }
        return (String)slot.getValue();
    }

    public static int getThreadPriority(@NotNull CRecord aRecord, int aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_THREAD_PRIORITY);
        if (slot == null) {
            return aDefault;
        }
        return (Integer)slot.getValue();
    }

    public static long getTimeStamp(@NotNull CRecord aRecord, long aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_TIME_STAMP);
        if (slot == null) {
            return aDefault;
        }
        return (Long)slot.getValue();
    }

    public static void setClass(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_CLASS, slot);
    }

    public static void setFile(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_FILE, slot);
    }

    public static void setFormattedMessage(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_FORMATTED_MESSAGE, slot);
    }

    public static void setIsNativeMethod(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.BOOLEAN, aValue);
        aRecord.addSlot(SLOT_IS_NATIVE_METHOD, slot);
    }

    public static void setLevel(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_LEVEL, slot);
    }

    public static void setLine(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_LINE, slot);
    }

    public static void setLoggerName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_LOGGER_NAME, slot);
    }

    public static void setMessage(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_MESSAGE, slot);
    }

    public static void setMethod(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_METHOD, slot);
    }

    public static void setProperties(@NotNull CRecord aRecord, CStringProperties aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING_PROPERTIES, aValue);
        aRecord.addSlot(SLOT_PROPERTIES, slot);
    }

    public static void setThreadId(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_THREAD_ID, slot);
    }

    public static void setThreadName(@NotNull CRecord aRecord, String aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING, aValue);
        aRecord.addSlot(SLOT_THREAD_NAME, slot);
    }

    public static void setThreadPriority(@NotNull CRecord aRecord, int aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.INT, aValue);
        aRecord.addSlot(SLOT_THREAD_PRIORITY, slot);
    }

    public static void setTimeStamp(@NotNull CRecord aRecord, long aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.LONG, aValue);
        aRecord.addSlot(SLOT_TIME_STAMP, slot);
    }
}

