/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilUuid;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.UUID;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotUuid
implements ISlot,
ISingleSlotTypeFactory {
    @Nullable
    private final UUID mValue;

    CSlotUuid() {
        this.mValue = null;
    }

    private CSlotUuid(@Nullable UUID aValue) {
        this.mValue = aValue;
    }

    @NotNull
    private static CSlotUuid fromObject(@Nullable Object aValue) {
        if (aValue instanceof UUID) {
            return new CSlotUuid((UUID)aValue);
        }
        if (aValue instanceof String) {
            return CSlotUuid.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotUuid.fromList((List)aValue);
        }
        return new CSlotUuid();
    }

    @NotNull
    private static CSlotUuid fromList(@NotNull List<?> aValue) {
        CSlotUuid result;
        if (aValue.isEmpty()) {
            result = new CSlotUuid();
        } else {
            Object object = aValue.get(0);
            result = CSlotUuid.fromObject(object);
        }
        return result;
    }

    @NotNull
    private static CSlotUuid fromStream(@NotNull DataInput aStream) throws IOException {
        UUID value = CUtilUuid.fromStream(aStream);
        return new CSlotUuid(value);
    }

    @NotNull
    private static CSlotUuid fromString(@NotNull String aValue) {
        UUID value = CUtilUuid.fromString(aValue);
        return new CSlotUuid(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotUuid.fromObject(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof String) {
            UUID v = CUtilUuid.fromString((String)aValue);
            return new CSlotUuid(v);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotUuid other = (CSlotUuid)aObj;
        return CUtilUuid.equals(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return UUID.class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        return this;
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.UUID;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Objects.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        return Objects.equals(this.mValue, aValue);
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotUuid.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilUuid.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return CUtilUuid.toShortString(this.mValue);
    }

    @Override
    @Contract(pure=true)
    @NotNull
    public String valueToString() {
        return CUtilUuid.toString(this.mValue);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (CUtilUuid.isValid(this.mValue)) {
            return CUtilUuid.toString(this.mValue);
        }
        return null;
    }
}

