/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.slot;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISingleSlotTypeFactory;
import de.sillysky.nyssr.slot.ISlot;
import de.sillysky.nyssr.util.CUtilStringArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

final class CSlotStringArray
implements ISlot,
ISingleSlotTypeFactory {
    private static final String IS_NULL = "#null";
    private final String[] mValue;

    CSlotStringArray() {
        this.mValue = null;
    }

    private CSlotStringArray(String @Nullable [] aValue) {
        this.mValue = CUtilStringArray.copy(aValue);
    }

    @NotNull
    private static CSlotStringArray create(@Nullable Object aValue) {
        if (aValue instanceof String[]) {
            return new CSlotStringArray((String[])aValue);
        }
        if (aValue instanceof String) {
            return CSlotStringArray.fromString((String)aValue);
        }
        if (aValue instanceof List) {
            return CSlotStringArray.fromList((List)aValue);
        }
        return new CSlotStringArray();
    }

    @NotNull
    private static CSlotStringArray fromList(@NotNull List<?> aList) {
        String[] array = CUtilStringArray.fromList(aList);
        return new CSlotStringArray(array);
    }

    @NotNull
    private static CSlotStringArray fromStream(@NotNull DataInput aStream) throws IOException {
        String[] array = CUtilStringArray.fromStream(aStream);
        return new CSlotStringArray(array);
    }

    @NotNull
    private static CSlotStringArray fromString(@NotNull String aValue) {
        String[] value = CUtilStringArray.fromString(aValue);
        return new CSlotStringArray(value);
    }

    @Override
    @Nullable
    public ISlot fromObject(@NotNull CSlotType aType, @Nullable Object aValue) {
        if (this.getType().equals(aType)) {
            return CSlotStringArray.create(aValue);
        }
        return null;
    }

    @Override
    @Nullable
    public ISlot fromJson(@Nullable Object aValue, @NotNull Map<Integer, byte[]> aByteArrayStore) {
        if (aValue instanceof CJsonArray) {
            CJsonArray arr = (CJsonArray)aValue;
            String[] values = new String[arr.size()];
            int i = 0;
            for (Object child : arr.getChildren()) {
                if (child instanceof String) {
                    String childString = (String)child;
                    if (IS_NULL.equals(childString)) {
                        values[i++] = null;
                        continue;
                    }
                    values[i++] = childString;
                    continue;
                }
                values[i++] = null;
            }
            return new CSlotStringArray(values);
        }
        return null;
    }

    @Override
    public boolean equals(@Nullable Object aObj) {
        if (this == aObj) {
            return true;
        }
        if (aObj == null) {
            return false;
        }
        if (this.getClass() != aObj.getClass()) {
            return false;
        }
        CSlotStringArray other = (CSlotStringArray)aObj;
        return CUtilStringArray.isEqual(this.mValue, other.mValue);
    }

    @Override
    @NotNull
    public Class<?> getClassOfProducedObject() {
        return String[].class;
    }

    @Override
    @NotNull
    public ISlot copy() {
        @NotNull String[] value = CUtilStringArray.copy(this.mValue);
        return new CSlotStringArray(value);
    }

    @Override
    @NotNull
    public CSlotType getType() {
        return CCommonSlotType.STRING_ARRAY;
    }

    @Override
    @Nullable
    public Object getValue() {
        return this.mValue;
    }

    @Override
    public int hashCode() {
        return Arrays.hashCode(this.mValue);
    }

    @Override
    public boolean isContentEqualTo(@Nullable Object aValue) {
        if (this.mValue == aValue) {
            return true;
        }
        if (this.mValue != null && aValue != null && aValue instanceof String[]) {
            String[] bb = (String[])aValue;
            return CUtilStringArray.isEqual(this.mValue, bb);
        }
        return false;
    }

    @Override
    @Nullable
    public ISlot readSlot(@NotNull DataInput aStream, @NotNull CSlotType aType) throws IOException {
        if (this.getType().equals(aType)) {
            return CSlotStringArray.fromStream(aStream);
        }
        return null;
    }

    @Override
    public void toStream(@NotNull DataOutput aStream) throws IOException {
        CUtilStringArray.toStream(aStream, this.mValue);
    }

    @NotNull
    public String toString() {
        return Arrays.toString(this.mValue);
    }

    @Override
    @NotNull
    public String valueToString() {
        return CUtilStringArray.toStringWithPipe(this.mValue);
    }

    @Override
    @Nullable
    public Object toJson(@NotNull Map<Integer, byte[]> aBinaries) {
        if (this.mValue != null && this.mValue.length > 0) {
            CJsonArray arr = new CJsonArray();
            for (String s : this.mValue) {
                arr.add(s == null ? IS_NULL : s);
            }
            return arr;
        }
        return null;
    }
}

