/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.kernel.config.file.manager;

import de.sillysky.nyssr.configuration.files.records.CRecordCreateConfigFile;
import de.sillysky.nyssr.configuration.files.records.CRecordDeleteConfigFile;
import de.sillysky.nyssr.configuration.files.records.CRecordGetConfigFileContent;
import de.sillysky.nyssr.configuration.files.records.CRecordSetConfigFileContent;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.impl.kernel.config.file.manager.IDependencies;
import de.sillysky.nyssr.login.records.CRecordSessionValidate;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.files.CUtilFile;
import de.sillysky.nyssr.util.files.CUtilPath;
import de.sillysky.nyssr.util.string.CUtilBase64;
import java.io.File;
import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.nio.file.Path;
import java.nio.file.Paths;
import org.jetbrains.annotations.NotNull;

class CWorkingTarget
extends CTarget {
    private static final IId MICRO_SERVICE_ID_SESSION = CIdFactory.fromObject("ccf168c1-f18b-4229-85f9-24461a19ee6a");
    private final IDependencies mDependencies;
    private final byte[] mSessionToken;
    private final CEnvelope mEnvelope;
    private final CRecord mRecord;

    CWorkingTarget(@NotNull IDependencies aDependencies, byte[] aSessionToken, @NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        this.mDependencies = aDependencies;
        this.mSessionToken = aSessionToken;
        this.mEnvelope = aEnvelope;
        this.mRecord = aRecord;
        this.mEnvelope.setBlocked(true);
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordSessionValidate.ID, this::asyncSessionValidate);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        this.sendSessionValidate();
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncSessionValidate(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) throws CException, IOException {
        if (aEnvelope.isAnswer()) {
            int resultCode = aEnvelope.getResultCode();
            if (resultCode == 0) {
                IId id;
                String userId = CRecordSessionValidate.getUserId(aRecord, null);
                String[] rights = CRecordSessionValidate.getRights(aRecord, null);
                if (!this.checkRights(rights)) {
                    this.sendFinished(5105, "Missing Right");
                }
                if (CRecordGetConfigFileContent.ID.equals(id = this.mRecord.getId())) {
                    this.getFileContent();
                } else if (CRecordSetConfigFileContent.ID.equals(id)) {
                    this.setFileContent();
                } else if (CRecordDeleteConfigFile.ID.equals(id)) {
                    this.deleteFile();
                } else if (CRecordCreateConfigFile.ID.equals(id)) {
                    this.createFile();
                } else {
                    this.sendFinished(15, "unknown message");
                }
            } else {
                this.sendFinished(resultCode, aEnvelope.getResultText());
            }
            return true;
        }
        return false;
    }

    private void deleteFile() throws CException {
        String pathString = CRecordDeleteConfigFile.getPath(this.mRecord, null);
        if (CUtilString.isEmpty(pathString)) {
            this.sendFinished(8, "path missing");
        } else {
            Path configurationPath = this.mDependencies.getKernelConfiguration().getConfigurationPath();
            Path path = Paths.get(pathString, new String[0]);
            if (!CUtilPath.isParent(path, configurationPath)) {
                this.sendFinished(15, "Not supported path");
            } else {
                boolean deleted = path.toFile().delete();
                if (!deleted) {
                    this.sendFinished(15, "Couldn't delete file");
                } else {
                    this.mDependencies.getConfigFileReader().notifyFileDeleted(path);
                    this.sendFinished(0, "");
                }
            }
        }
    }

    private void createFile() throws CException, IOException {
        String filename = CRecordCreateConfigFile.getFilename(this.mRecord, null);
        String content = CRecordCreateConfigFile.getContent(this.mRecord, null);
        if (CUtilString.isValid(content)) {
            content = CUtilBase64.decodeString(content);
        }
        Path configurationPath = this.mDependencies.getKernelConfiguration().getConfigurationPath();
        Path path = configurationPath.resolve(filename);
        File file = path.toFile();
        CUtilFile.overwrite(file, content == null ? "" : content);
        CRecordCreateConfigFile.setPath(this.mRecord, path.toString());
        this.sendFinished(0, "");
    }

    private void setFileContent() throws CException, IOException {
        String pathString = CRecordSetConfigFileContent.getPath(this.mRecord, null);
        if (CUtilString.isEmpty(pathString)) {
            this.sendFinished(8, "path missing");
            return;
        }
        String content = CRecordSetConfigFileContent.getContent(this.mRecord, null);
        if (content == null) {
            this.sendFinished(8, "content missing");
            return;
        }
        if ((content = CUtilBase64.decodeString(content)) == null) {
            this.sendFinished(6, "content must be base64 encoded");
            return;
        }
        File file = new File(pathString);
        CUtilFile.overwrite(file, content);
        this.sendFinished(0, "");
    }

    private void getFileContent() throws CException {
        String pathString = CRecordSetConfigFileContent.getPath(this.mRecord, null);
        if (CUtilString.isEmpty(pathString)) {
            this.sendFinished(8, "path missing");
            return;
        }
        Path configurationPath = this.mDependencies.getKernelConfiguration().getConfigurationPath();
        Path path = Paths.get(pathString, new String[0]);
        if (!CUtilPath.isParent(path, configurationPath)) {
            this.sendFinished(15, "Not supported path");
            return;
        }
        try {
            String s = CUtilFile.readTextFile(path, StandardCharsets.UTF_8);
            String encoded = CUtilBase64.encodeToStringWithPrefix(s);
            CRecordGetConfigFileContent.setContent(this.mRecord, encoded);
            this.sendFinished(0, "");
        }
        catch (IOException aE) {
            this.sendFinished(2, aE.getMessage());
        }
    }

    private boolean checkRights(String[] aRights) {
        if (aRights != null) {
            for (String right : aRights) {
                if (!right.equalsIgnoreCase("NY_EditConfiguration")) continue;
                return true;
            }
        }
        return false;
    }

    private void sendSessionValidate() throws CException {
        CEnvelope env = CEnvelope.forMicroService(MICRO_SERVICE_ID_SESSION);
        env.setSessionToken(this.mSessionToken);
        CRecord record = CRecordSessionValidate.create();
        this.sendRequest(env, record);
    }

    private void sendFinished(int aResultCode, @NotNull String aResultText) throws CException {
        this.mEnvelope.setResult(aResultCode, aResultText);
        this.mEnvelope.setBlocked(false);
        this.getMessageSender().sendBack(this.mEnvelope, this.mRecord);
        this.deregisterTarget();
    }
}

