/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.cli.records;

import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordCliAddHandler
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("3eaa3a56-5a84-4f11-b2fc-62da19141013");
    public static final String NAME = "CliAddHandler";
    public static final String DESCRIPTION = "Add a Command Handler.";
    public static final String SLOT_COMMAND = "1";
    public static final String SLOT_HELP = "2";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static String[] getCommand(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_COMMAND);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static String[] getHelp(@NotNull CRecord aRecord, String[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_HELP);
        if (slot == null) {
            return aDefault;
        }
        return (String[])slot.getValue();
    }

    public static void setCommand(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING_ARRAY, aValue);
        aRecord.addSlot(SLOT_COMMAND, slot);
    }

    public static void setHelp(@NotNull CRecord aRecord, String[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.STRING_ARRAY, aValue);
        aRecord.addSlot(SLOT_HELP, slot);
    }
}

