/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.address;

import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.CUtilStringArray;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilSegmentIdArray {
    public static final CSegmentId[] EMPTY = new CSegmentId[0];

    private CUtilSegmentIdArray() {
    }

    public static boolean contains(@Nullable CSegmentId aSegmentId, @Nullable CSegmentId[] aArray) {
        if (aArray != null && aSegmentId != null) {
            for (CSegmentId id : aArray) {
                if (!aSegmentId.equals(id)) continue;
                return true;
            }
        }
        return false;
    }

    public static CSegmentId[] fromList(@Nullable List<?> aList) {
        if (aList == null || aList.isEmpty()) {
            return EMPTY;
        }
        ArrayList<CSegmentId> list = new ArrayList<CSegmentId>();
        for (Object element : aList) {
            CSegmentId id;
            if (element == null) continue;
            if (element instanceof CSegmentId) {
                id = (CSegmentId)element;
                list.add(id);
                continue;
            }
            if (element instanceof CSegmentId[]) {
                CSegmentId[] ids = (CSegmentId[])element;
                Collections.addAll(list, ids);
                continue;
            }
            id = CSegmentId.fromObject(element);
            list.add(id);
        }
        CSegmentId[] arr = new CSegmentId[list.size()];
        int i = 0;
        Iterator iterator = list.iterator();
        while (iterator.hasNext()) {
            CSegmentId id;
            arr[i] = id = (CSegmentId)iterator.next();
            ++i;
        }
        return arr;
    }

    public static @NotNull CSegmentId @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        CSegmentId[] array = new CSegmentId[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            array[i] = CSegmentId.fromStream(aStream);
        }
        return array;
    }

    @NotNull
    public static CSegmentId[] fromString(@NotNull String aValue) {
        String[] stringArray = CUtilStringArray.fromString(aValue);
        return CUtilSegmentIdArray.fromStringArray(stringArray);
    }

    @NotNull
    private static CSegmentId[] fromStringArray(@Nullable String[] aList) {
        if (aList == null || aList.length == 0) {
            return EMPTY;
        }
        CSegmentId[] array = new CSegmentId[aList.length];
        int i = 0;
        for (String element : aList) {
            array[i] = CUtilString.isEmpty(element) ? CSegmentId.EMPTY : new CSegmentId(element);
            ++i;
        }
        return array;
    }

    public static CSegmentId[] copy(@Nullable CSegmentId[] aValue) {
        if (aValue == null) {
            return null;
        }
        return Arrays.copyOf(aValue, aValue.length);
    }

    public static boolean isArrayEqual(@Nullable CSegmentId[] aValue1, @Nullable CSegmentId[] aValue2) {
        if (aValue1 == null) {
            return aValue2 == null;
        }
        if (aValue2 == null) {
            return false;
        }
        for (int i = 0; i < aValue1.length; ++i) {
            if (CSegmentId.equals(aValue1[i], aValue2[i])) continue;
            return false;
        }
        return true;
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable @Nullable CSegmentId @Nullable [] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (CSegmentId element : aValue) {
                CSegmentId.toStream(aStream, element);
            }
        }
    }

    @NotNull
    public static String toString(@Nullable CSegmentId[] aValue) {
        if (aValue == null || aValue.length == 0) {
            return "";
        }
        String[] arr = new String[aValue.length];
        for (int i = 0; i < aValue.length; ++i) {
            arr[i] = aValue[i] == null ? "" : aValue[i].valueToString();
        }
        return CUtilStringArray.toStringWithPipe(arr);
    }

    public static void toStringList(CSegmentId[] aValue, List<String> aList) {
        if (aValue != null && aValue.length > 0) {
            for (CSegmentId element : aValue) {
                String s = element.valueToString();
                aList.add(s);
            }
        }
    }

    @NotNull
    public static @NotNull CSegmentId @NotNull [] random(int aSize, boolean aWithNullValues) {
        CSegmentId[] arr = new CSegmentId[aSize];
        for (int i = 0; i < aSize; ++i) {
            if (aWithNullValues) {
                boolean isNull = CUtilRandom.getRandom().nextBoolean();
                if (isNull) {
                    arr[i] = null;
                    continue;
                }
                arr[i] = CSegmentId.random();
                continue;
            }
            arr[i] = CSegmentId.random();
        }
        return arr;
    }
}

