/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.address;

import de.sillysky.nyssr.address.CNamespaceAddress;
import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CSegmentId;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.EIdType;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilString;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.util.Objects;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CTargetAddress {
    private static final CTargetAddress INVALID = new CTargetAddress(IId.INVALID, IId.INVALID, CNodeId.getEmpty());
    private static final int MAX_RANDOM_ARRAY_SIZE = 4000;
    private static final int RANDOM_NULL = 3;
    @NotNull
    private final CNamespaceAddress mNamespaceAddress;
    @NotNull
    private final IId mTID;

    public CTargetAddress(@NotNull IId aTID, @NotNull IId aNID, @NotNull CNodeId aNodeId, @NotNull CSegmentId aSegmentId) {
        CUtilCheck.checkNotNull(aTID, "TID is null", new Object[0]);
        this.mTID = aTID;
        CNodeAddress nodeAddress = new CNodeAddress(aNodeId, aSegmentId);
        this.mNamespaceAddress = new CNamespaceAddress(aNID, nodeAddress);
    }

    public CTargetAddress(@NotNull IId aTID, @NotNull IId aNID, @NotNull CNodeId aNodeId) {
        this(aTID, aNID, aNodeId, CSegmentId.EMPTY);
    }

    public CTargetAddress(@NotNull IId aTID, @NotNull IId aNID, @NotNull CNodeAddress aNodeAddress) {
        this(aTID, aNID, aNodeAddress.getNodeId(), aNodeAddress.getSegmentId());
    }

    public CTargetAddress(@NotNull IId aTID, @NotNull IId aNID) {
        this(aTID, aNID, CNodeId.EMPTY, CSegmentId.EMPTY);
    }

    public CTargetAddress(@NotNull IId aTID, @NotNull CNamespaceAddress aNamespaceAddress) {
        CUtilCheck.checkNotNull(aTID, "TID is null", new Object[0]);
        this.mTID = aTID;
        this.mNamespaceAddress = aNamespaceAddress;
    }

    @Nullable
    public static CTargetAddress fromString(@Nullable String aStr) {
        if (CUtilString.isEmpty(aStr)) {
            return null;
        }
        int pos = aStr.indexOf(46);
        if (pos < 0) {
            return new CTargetAddress(IId.INVALID, IId.INVALID, CNodeId.getEmpty());
        }
        CNamespaceAddress nsa = CNamespaceAddress.fromString(aStr.substring(pos + 1));
        if (pos == 0) {
            return new CTargetAddress(IId.INVALID, nsa);
        }
        String tidString = aStr.substring(0, pos);
        IId tid = CIdFactory.fromObject(tidString);
        return new CTargetAddress(tid, nsa);
    }

    @NotNull
    public static CTargetAddress fromObject(@Nullable Object aTID, @Nullable Object aNID, @Nullable Object aNodeId) {
        IId tid = CIdFactory.fromObject(aTID);
        IId nid = CIdFactory.fromObject(aNID);
        CNodeId nodeId = CNodeId.fromObject(aNodeId);
        return new CTargetAddress(tid, nid, nodeId);
    }

    @NotNull
    public static CTargetAddress random() {
        return new CTargetAddress(CIdFactory.randomOfType(EIdType.INT), CNamespaceAddress.random());
    }

    @Nullable
    public static CTargetAddress[] randomArray(int aSize, boolean aWithNullValues) {
        if (aSize < 0) {
            return null;
        }
        int size = Math.min(aSize, 4000);
        CTargetAddress[] array = new CTargetAddress[size];
        for (int i = 0; i < aSize; ++i) {
            int r = CUtilRandom.getRandom().nextInt(3);
            if (r == 0) {
                if (aWithNullValues) {
                    array[i] = null;
                    continue;
                }
                array[i] = INVALID;
                continue;
            }
            array[i] = CTargetAddress.random();
        }
        return array;
    }

    @NotNull
    public static CTargetAddress getInvalidAddress() {
        return INVALID;
    }

    public static boolean hasValidTID(@Nullable CTargetAddress aAddress) {
        return aAddress != null && CIdFactory.isValid(aAddress.getTID());
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable CTargetAddress aValue) throws IOException {
        if (aValue == null) {
            aStream.writeBoolean(false);
        } else {
            aStream.writeBoolean(true);
            CIdFactory.toStream(aStream, aValue.mTID);
            CNamespaceAddress.toStream(aStream, aValue.mNamespaceAddress);
        }
    }

    @Nullable
    public static CTargetAddress fromStream(@NotNull DataInput aStream) throws IOException {
        boolean valid = aStream.readBoolean();
        if (valid) {
            IId tid = CIdFactory.fromStream(aStream, true);
            CNamespaceAddress na = CNamespaceAddress.fromStream(aStream);
            if (tid != null && na != null) {
                return new CTargetAddress(tid, na);
            }
        }
        return null;
    }

    @NotNull
    public static String valueToString(@Nullable CTargetAddress aValue) {
        if (aValue == null) {
            return "null";
        }
        return aValue.valueToString();
    }

    @NotNull
    public CNamespaceAddress getNamespaceAddress() {
        return this.mNamespaceAddress;
    }

    @NotNull
    public CTargetAddress changeNID(@Nullable IId aNID) {
        IId nid = CIdFactory.getNonNullId(aNID);
        if (!this.getNID().equals(nid)) {
            return new CTargetAddress(this.mTID, nid, this.getNodeId());
        }
        return this;
    }

    @NotNull
    public CTargetAddress changeNodeId(@Nullable CNodeId aNodeId) {
        CNodeId nodeId = CNodeId.getNonNullNodeId(aNodeId);
        if (!this.getNodeId().equals(nodeId)) {
            return new CTargetAddress(this.mTID, this.getNID(), nodeId);
        }
        return this;
    }

    @NotNull
    public CTargetAddress changeNodeAddress(@Nullable CNodeAddress aNode) {
        CNodeAddress node;
        CNodeAddress cNodeAddress = node = aNode == null ? CNodeAddress.EMPTY : aNode;
        if (!this.getNamespaceAddress().getNodeAddress().equals(node)) {
            return new CTargetAddress(this.mTID, this.getNID(), node);
        }
        return this;
    }

    @NotNull
    public CTargetAddress changeTID(@Nullable IId aTID) {
        IId tid = CIdFactory.getNonNullId(aTID);
        if (!this.mTID.equals(tid)) {
            return new CTargetAddress(tid, this.getNID(), this.getNodeId());
        }
        return this;
    }

    public boolean equals(@Nullable Object aObject) {
        if (this == aObject) {
            return true;
        }
        if (aObject == null) {
            return false;
        }
        if (!(aObject instanceof CTargetAddress)) {
            return false;
        }
        CTargetAddress other = (CTargetAddress)aObject;
        return this.match(other);
    }

    @NotNull
    public IId getNID() {
        return this.mNamespaceAddress.getNID();
    }

    @NotNull
    public CNodeId getNodeId() {
        return this.mNamespaceAddress.getNodeId();
    }

    @NotNull
    public CNodeAddress getNodeAddress() {
        return this.mNamespaceAddress.getNodeAddress();
    }

    @NotNull
    public CSegmentId getSegmentId() {
        return this.mNamespaceAddress.getSegmentId();
    }

    @NotNull
    public IId getTID() {
        return this.mTID;
    }

    public int hashCode() {
        return Objects.hash(this.mTID, this.mNamespaceAddress);
    }

    public boolean isLocalNode() {
        return this.mNamespaceAddress.getNodeAddress().isLocalNode();
    }

    public boolean isValid() {
        return this.mTID.isValid();
    }

    public boolean match(@Nullable IId aTID) {
        return this.mTID.equals(aTID);
    }

    public boolean match(@Nullable IId aTID, @Nullable IId aNID, @Nullable CNodeId aNodeId, @Nullable CSegmentId aSegmentId) {
        CNamespaceAddress namespaceAddress = this.getNamespaceAddress();
        CNodeAddress nodeAddress = namespaceAddress.getNodeAddress();
        return this.match(aTID) && namespaceAddress.matchNid(aNID) && nodeAddress.matchNodeId(aNodeId) && nodeAddress.matchSegmentId(aSegmentId);
    }

    public boolean match(@Nullable CTargetAddress aOther) {
        if (this == aOther) {
            return true;
        }
        if (aOther == null) {
            return false;
        }
        return this.match(aOther.getTID(), aOther.getNID(), aOther.getNodeId(), aOther.getSegmentId());
    }

    public boolean matchNid(@Nullable IId aNID) {
        return this.mNamespaceAddress.matchNid(aNID);
    }

    @NotNull
    public String toNamespaceString() {
        return this.mNamespaceAddress.toNamespaceString();
    }

    @NotNull
    public String toString() {
        return this.mTID.toString() + '.' + this.getNID() + '.' + this.getNodeId() + '.' + this.getSegmentId();
    }

    @NotNull
    public String valueToString() {
        return this.mTID.valueToString() + '.' + this.getNID().valueToString() + '.' + this.getNodeId().valueToString() + '.' + this.getSegmentId().valueToString();
    }

    @Nullable
    public CTargetAddress getCompletedAddress() {
        CSegmentId segmentId;
        boolean create = false;
        CNodeId nodeId = this.getNodeId();
        if (nodeId.isEmpty()) {
            nodeId = CNodeId.getLocal();
            create = true;
        }
        if ((segmentId = this.getSegmentId()).isEmpty()) {
            segmentId = CSegmentId.getLocal();
            create = true;
        }
        return create ? new CTargetAddress(this.mTID, this.getNID(), nodeId, segmentId) : null;
    }
}

