/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.tcp.server;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.impl.tcp.server.IDependencies;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.tcp.ITcpServer;
import org.jetbrains.annotations.NotNull;

final class CTargetForTcpServer
extends CTarget {
    private static final ILogger LOG = CLoggerFactory.getLogger(CTargetForTcpServer.class);
    private ITcpServer mServer;
    private IDependencies mDependencies;

    CTargetForTcpServer() {
    }

    void activate(@NotNull IDependencies aDependencies, @NotNull ITcpServer aServer) throws CException {
        this.mDependencies = aDependencies;
        LOG.debug("Activate {} {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), System.identityHashCode((Object)this)});
        this.mServer = aServer;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.mDependencies.getNamespace().getTargetRegistry().registerTarget((ITarget)this);
    }

    private boolean asyncStartTarget(@NotNull CEnvelope aEnvelope, @NotNull CRecord aRecord) {
        if (aEnvelope.isAnswer()) {
            return false;
        }
        CTargetAddress address = this.getAddress();
        this.mDependencies.getNameDb().getTargetAddressDatabase().putName(address, "TcpServer");
        aEnvelope.setResultSuccess();
        return true;
    }

    void deactivate() {
        LOG.debug("Deactivate {} {}", new Object[]{((Object)((Object)this)).getClass().getSimpleName(), System.identityHashCode((Object)this)});
        this.deregisterTarget();
        this.mServer = null;
    }
}

