/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.network.broadcast.records;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordBroadcastSendMsg
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"bec781a3-0250-4bcc-9750-f33e0c3dd3ef");
    public static final String NAME = "BroadcastSendMsg";
    public static final String DESCRIPTION = "Send a broadcast message per flooding to other nodes.";
    public static final String SLOT_LOCALLY = "2";
    public static final String SLOT_MESSAGE = "1";
    public static final String SLOT_NEGATIVE_FILTER = "4";
    public static final String SLOT_POSITIVE_FILTER = "3";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static boolean getLocally(@NotNull CRecord aRecord, boolean aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_LOCALLY);
        if (slot == null) {
            return aDefault;
        }
        return (Boolean)slot.getValue();
    }

    public static CMessage getMessage(@NotNull CRecord aRecord, CMessage aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MESSAGE);
        if (slot == null) {
            return aDefault;
        }
        return (CMessage)slot.getValue();
    }

    public static CNodeAddress[] getNegativeFilter(@NotNull CRecord aRecord, CNodeAddress[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NEGATIVE_FILTER);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress[])slot.getValue();
    }

    public static CNodeAddress[] getPositiveFilter(@NotNull CRecord aRecord, CNodeAddress[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_POSITIVE_FILTER);
        if (slot == null) {
            return aDefault;
        }
        return (CNodeAddress[])slot.getValue();
    }

    public static void setLocally(@NotNull CRecord aRecord, boolean aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.BOOLEAN, (Object)aValue);
        aRecord.addSlot(SLOT_LOCALLY, slot);
    }

    public static void setMessage(@NotNull CRecord aRecord, CMessage aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.MESSAGE, (Object)aValue);
        aRecord.addSlot(SLOT_MESSAGE, slot);
    }

    public static void setNegativeFilter(@NotNull CRecord aRecord, CNodeAddress[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_NEGATIVE_FILTER, slot);
    }

    public static void setPositiveFilter(@NotNull CRecord aRecord, CNodeAddress[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.NODE_ADDRESS_ARRAY, (Object)aValue);
        aRecord.addSlot(SLOT_POSITIVE_FILTER, slot);
    }
}

