/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.remoteskin.model.events;

import de.sillysky.nyssr.json.CJsonArray;
import de.sillysky.nyssr.json.CJsonObject;
import de.sillysky.nyssr.remoteskin.model.events.IRemoteSkinEvent;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CEventTableSelectionNotification
implements IRemoteSkinEvent {
    public static final String ROWS = "rows";
    public static final String COLUMNS = "columns";
    private final Set<String> mSelectedRowIds = new HashSet<String>();
    private final Set<String> mSelectedColumnIds = new HashSet<String>();

    public static CEventTableSelectionNotification create(@Nullable Object aValue) {
        if (aValue instanceof CJsonObject) {
            CJsonObject jo = (CJsonObject)aValue;
            List<String> rows = CEventTableSelectionNotification.readList(jo, ROWS);
            List<String> columns = CEventTableSelectionNotification.readList(jo, COLUMNS);
            if (rows != null || columns != null) {
                CEventTableSelectionNotification event = new CEventTableSelectionNotification();
                event.setRows(rows);
                event.setColumns(columns);
                return event;
            }
        }
        return null;
    }

    private static List<String> readList(@NotNull CJsonObject aJo, @NotNull String aId) {
        ArrayList<String> list = null;
        Object o = aJo.getValue(aId);
        if (o instanceof CJsonArray) {
            list = new ArrayList<String>();
            CJsonArray arr = (CJsonArray)o;
            List children = arr.getChildren();
            for (Object child : children) {
                if (!(child instanceof String)) continue;
                list.add((String)child);
            }
            return list.isEmpty() ? null : list;
        }
        return list;
    }

    public void addSelectedRow(@NotNull String aRowId) {
        this.mSelectedRowIds.add(aRowId);
    }

    public void addSelectedColumn(@NotNull String aColumnId) {
        this.mSelectedColumnIds.add(aColumnId);
    }

    @Override
    @NotNull
    public Object toJson() {
        CJsonObject jo = new CJsonObject(true);
        CJsonArray rows = new CJsonArray(this.mSelectedRowIds);
        jo.put(ROWS, (Object)rows);
        CJsonArray columns = new CJsonArray(this.mSelectedColumnIds);
        jo.put(COLUMNS, (Object)columns);
        return jo;
    }

    public Collection<String> getSelectedRowIds() {
        return this.mSelectedRowIds;
    }

    public Collection<String> getSelectedColumnIds() {
        return this.mSelectedColumnIds;
    }

    private void setRows(@Nullable List<String> aRows) {
        if (aRows != null) {
            this.mSelectedRowIds.addAll(aRows);
        }
    }

    private void setColumns(@Nullable List<String> aColumns) {
        if (aColumns != null) {
            this.mSelectedColumnIds.addAll(aColumns);
        }
    }
}

