/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.microservice.registry.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.CSlotType;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNotifyMicroServiceInstanceRemoved
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject((Object)"39ca42be-74a2-4aa9-b495-cb878a624d49");
    public static final String NAME = "NotifyMicroServiceInstanceRemoved";
    public static final String DESCRIPTION = "From one MicroService to another one: Notification that a single Micro Service instance has been removed.";
    public static final String SLOT_ADDRESS = "3";
    public static final String SLOT_INSTANCE_ID = "2";
    public static final String SLOT_MICRO_SERVICE_ID = "1";
    public static final String[] NAMESPACES = new String[0];
    public static final boolean IS_NANO_SERVICE = false;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static CTargetAddress getAddress(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_ADDRESS);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static IId getInstanceId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_INSTANCE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static IId getMicroServiceId(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_MICRO_SERVICE_ID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static void setAddress(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.TARGET_ADDRESS, (Object)aValue);
        aRecord.addSlot(SLOT_ADDRESS, slot);
    }

    public static void setInstanceId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID, (Object)aValue);
        aRecord.addSlot(SLOT_INSTANCE_ID, slot);
    }

    public static void setMicroServiceId(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject((CSlotType)CCommonSlotType.ID, (Object)aValue);
        aRecord.addSlot(SLOT_MICRO_SERVICE_ID, slot);
    }
}

