
export async function getSHA384Base64(input) {
    // Convert the input string to UTF-8 encoded bytes
    const encoder = new TextEncoder();
    const data = encoder.encode(input);

    // Hash the data with SHA-384
    const hashBuffer = await crypto.subtle.digest('SHA-384', data);

    // Convert the hash to a Base64 encoded string
    const hashArray = Array.from(new Uint8Array(hashBuffer));
    return btoa(hashArray.map(byte => String.fromCharCode(byte)).join(''));
}

export function getInputValue(inputElement) {
    if (inputElement.type === 'checkbox') {
        return inputElement.checked;
    } else {
        return inputElement.value;
    }
}

export function sendMessage(socket,message) {
    if (socket.readyState === WebSocket.OPEN) {
        // send JSON text
        let jsonData = JSON.stringify(message);
        //alert(jsonData);
        socket.send(jsonData);
        console.log("JSON text sent: ", jsonData);
    } else {
        console.log("WebSocket connection not opened.");
    }
}

// Function to convert a map into a JSON object
export function mapToJson(map) {
    // Convert the map into an object
    const obj = Object.fromEntries(map);

    // Iterate
    for (const [key, value] of Object.entries(obj)) {
        // Check if the value is a map
        if (value instanceof Map) {
            // Recursive call to convert the nested map into an object
            obj[key] = mapToJson(value);
        }
    }

    return obj;
}

// Function for adding a stylesheet as text
export function addStylesheetText(id, cssText) {
    // Check whether a style element with this ID already exists
    if (document.getElementById(id)) {
        console.log("Stylesheet with this ID already exists.");
        return;
    }

    // Create new <style> element
    var style = document.createElement("style");
    style.id = id;
    style.textContent = cssText;

    // Add <style> element to the <head>
    document.head.appendChild(style);
    console.log("Stylesheet added:", id);
}

// Function for removing a stylesheet as text
export function removeStylesheetText(id) {
    // Find <style> element with the specified ID
    var style = document.getElementById(id);

    if (style) {
        // Remove <style> element from the <head>
        document.head.removeChild(style);
        console.log("Stylesheet removed:", id);
    } else {
        console.log("No stylesheet with this ID found.");
    }
}

// Create a function to replace the URL parameters
export function replaceURLParams(paramMap) {
    let currentURL = new URL(window.location.href);
    for (let [key, value] of paramMap) {
        currentURL.searchParams.set(key, value);
    }
    return currentURL;
}

export function replaceElementValue(elementId, newValue) {
    // Select the element
    var element = document.getElementById(elementId);

    // Check the element type and replace its value accordingly
    if (element.tagName === 'INPUT') {
        element.value = newValue;
    } else if (element.tagName === 'TEXTAREA') {
        element.value = newValue;
    } else if (element.tagName === 'SELECT') {
        for (var i = 0; i < element.options.length; i++) {
            if (element.options[i].value === newValue) {
                element.selectedIndex = i;
                break;
            }
        }
    } else {
        console.log('Unsupported element type');
    }
}