#!/bin/bash

#
# Copyright (c) since 2023 by sillysky.net.
# All rights reserved.
# This file is subject to the terms and conditions defined in file 'LICENSE.txt',
# which is part of this source code package.
#

if [ "$#" -eq 0 ]; then
    echo "Error: No node ID specified as a parameter."
    echo "Usage: $0 <nodeid>"
    exit 1
fi

restart() {
    java -cp "../lib/*" de.sillysky.nyssr.impl.kernel.CKernel node.id=$1
    exitCode=$?

    case $exitCode in
        1)
            restart
            ;;
        2)
            updateLib
            ;;
        3)
            updatePlugins
            ;;
        4)
            updateBoth
            ;;
        *)
            exit 0
            ;;
    esac
}

updateLib() {
    echo "LIB Update is being performed..."
    rm -rf ../lib/*
    cp -r ./update/new_files/lib/*.jar ../lib
    echo "Update completed. Application is restarted..."
    restart
}

updatePlugins() {
    echo "PLUGIN Update is being performed..."
    rm -rf ../plugins/*
    cp -r ./update/new_files/plugins/*.jar ../plugins
    echo "Update completed. Application is restarted..."
    restart
}

updateBoth() {
    echo "LIB and PLUGIN Update is being performed..."
    rm -rf ../lib/*
    cp -r ./update/new_files/lib/*.jar ../lib
    rm -rf ../plugins/*
    cp -r ./update/new_files/plugins/*.jar ../plugins
    echo "Update completed. Application is restarted..."
    restart
}

restart
