/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.node.list;

import de.sillysky.nyssr.address.CNodeAddress;
import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.widget.CWidgetId;
import de.sillysky.nyssr.id.widget.CWidgetSetId;
import de.sillysky.nyssr.impl.network.node.list.CNodeListModel;
import de.sillysky.nyssr.network.nodeinfo.CNodeInfo;
import de.sillysky.nyssr.remoteskin.model.events.CEventLabelItem;
import de.sillysky.nyssr.remoteskin.model.events.CEventListContent;
import de.sillysky.nyssr.remoteskin.model.events.CEventListSelectionNotification;
import de.sillysky.nyssr.remoteskin.model.events.CEventTextChangeNotification;
import de.sillysky.nyssr.remoteskin.server.context.IRemoteSkinServerContext;
import de.sillysky.nyssr.remoteskin.server.context.IWidgetApi;
import de.sillysky.nyssr.remoteskin.server.listeners.IButtonPressedListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListSelectionListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IMouseListener;
import de.sillysky.nyssr.remoteskin.server.listeners.IPopupListener;
import de.sillysky.nyssr.remoteskin.server.listeners.ITextChangeListener;
import de.sillysky.nyssr.util.CUtilString;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.TreeSet;
import java.util.UUID;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

class CNodeListUi {
    private final IWidgetApi mApi;
    private final CNodeListModel mModel;
    private final CWidgetId mNodeList;
    private final CWidgetId mTextFieldNodeId;
    private final CWidgetId mTextFieldNodeName;
    private final CWidgetId mTextFieldNodeDescription;
    private final CWidgetId mTextFieldNodeVendor;
    private final CWidgetId mTextFieldNodeLicense;

    CNodeListUi(@NotNull CNodeListModel aModel) {
        this.mModel = aModel;
        this.mApi = this.mModel.getDialogDto().getServerContext().getWidgetApi();
        String instance = this.mModel.getNextInstance();
        CWidgetSetId ws200 = CWidgetSetId.create((String)"@200_ChooseNode", (String)instance);
        this.mModel.setWs200(ws200);
        this.mNodeList = CWidgetId.create((String)"#200_List", (CWidgetSetId)ws200);
        this.mApi.addListener(this.mNodeList, (IListener)((IListSelectionListener)this::onSelectNode));
        this.mApi.addListener(this.mNodeList, (IListener)((IMouseListener)ev -> this.openNode(ev.getValue())));
        CWidgetId textFieldFilter = CWidgetId.create((String)"#200_TextField_Filter", (CWidgetSetId)ws200);
        this.mApi.addListener(textFieldFilter, (IListener)((ITextChangeListener)this::onTextChangeFilter));
        CWidgetId buttonOpen = CWidgetId.create((String)"#200_Button_OpenNodeInfo", (CWidgetSetId)ws200);
        this.mApi.addListener(buttonOpen, (IListener)((IButtonPressedListener)cmd -> this.onButtonOpen()));
        CWidgetSetId ws201 = CWidgetSetId.create((String)"@201_PopupNode", (String)instance);
        CWidgetId menuItemOpenNode = CWidgetId.create((String)"#201_MenuItem_OpenNodeInfo", (CWidgetSetId)ws201);
        this.mApi.addListener(menuItemOpenNode, (IListener)((IPopupListener)aEvent -> this.onMenuOpen(aEvent.getValue())));
        CWidgetSetId ws202 = CWidgetSetId.create((String)"@202_NodeDescription", (String)instance);
        this.mTextFieldNodeId = CWidgetId.create((String)"#202_TextField_NodeId", (CWidgetSetId)ws202);
        this.mTextFieldNodeName = CWidgetId.create((String)"#202_TextField_Name", (CWidgetSetId)ws202);
        this.mTextFieldNodeDescription = CWidgetId.create((String)"#202_TextField_Description", (CWidgetSetId)ws202);
        this.mTextFieldNodeVendor = CWidgetId.create((String)"#202_TextField_Vendor", (CWidgetSetId)ws202);
        this.mTextFieldNodeLicense = CWidgetId.create((String)"#202_TextField_License", (CWidgetSetId)ws202);
    }

    private void widgetSet200Mounted(@NotNull CWidgetSetId aWidgetSetId) {
        if (this.mModel.getWs200().equals((Object)aWidgetSetId)) {
            CTargetAddress address = this.mModel.getDialogTarget().getAddress();
            CNodeAddress nodeAddress = address.getNodeAddress();
            this.mModel.setSelectedNodeAddress(nodeAddress);
            CNodeInfo nodeInfo = this.mModel.getNodeInfo(nodeAddress);
            if (nodeInfo != null) {
                this.sendListContent(this.mModel.getFilter(), nodeInfo);
                this.fillFields(nodeInfo);
            }
        }
    }

    private void onSelectNode(@NotNull CEventListSelectionNotification aEvent) {
        block0: {
            String id;
            CNodeId nodeId;
            CNodeInfo nodeRecord;
            List selectedIds = aEvent.getSelectedIds();
            Iterator iterator = selectedIds.iterator();
            if (!iterator.hasNext() || (nodeRecord = this.mModel.getNodeInfo(nodeId = CNodeId.fromObject((Object)(id = (String)iterator.next())))) == null) break block0;
            this.mModel.setSelectedNodeAddress(nodeRecord.getNodeAddress());
            this.fillFields(nodeRecord);
        }
    }

    void openNode(@Nullable String aEntry) throws CException {
        CNodeInfo node;
        if (CUtilString.isValid((String)aEntry) && (node = this.itemToNodeRecord(aEntry)) != null) {
            this.mModel.setSelectedNodeAddress(node.getNodeAddress());
            this.fillFields(node);
            this.mModel.getDialogTarget().sendNodeId(node);
        }
    }

    private void fillFields(@Nullable CNodeInfo aRec) {
        if (aRec != null) {
            this.mApi.setText(this.mTextFieldNodeId, aRec.getNodeAddress().valueToString());
            this.mApi.setText(this.mTextFieldNodeName, aRec.getName());
            this.mApi.setText(this.mTextFieldNodeDescription, aRec.getDescription());
            this.mApi.setText(this.mTextFieldNodeVendor, aRec.getVendor());
            UUID license = aRec.getLicense();
            this.mApi.setText(this.mTextFieldNodeLicense, license == null ? "" : license.toString());
            this.mModel.getDialogDto().getServerContext().sendUpdate();
        }
    }

    @Nullable
    private CNodeInfo itemToNodeRecord(@Nullable String aListItem) {
        int index;
        String s;
        CNodeAddress n;
        if (CUtilString.isValid((String)aListItem) && (n = CNodeAddress.fromString((String)(s = (index = aListItem.indexOf(40)) > 0 ? aListItem.substring(0, index).trim() : aListItem))).isValid()) {
            return this.mModel.getNodeInfo(n);
        }
        return null;
    }

    private void onButtonOpen() throws CException {
        String selectedEntry = this.mModel.getSelectedNodeAddress().valueToString();
        this.openNode(selectedEntry);
    }

    private void onMenuOpen(@Nullable String aValue) throws CException {
        this.openNode(aValue);
    }

    void sendListContent(@NotNull String aFilter, @Nullable CNodeInfo aSelectedNode) {
        CEventListContent event = new CEventListContent();
        Collection<CNodeInfo> nodes = this.mModel.getNodes();
        TreeSet<CNodeInfo> nodes2 = new TreeSet<CNodeInfo>(nodes);
        for (CNodeInfo dto : nodes2) {
            if (!dto.getName().contains(aFilter)) continue;
            CNodeId nodeId = dto.getNodeAddress().getNodeId();
            CEventLabelItem item = new CEventLabelItem(nodeId.valueToString());
            item.getAttributes().setValue((Object)dto.toString());
            event.add(item);
        }
        this.mApi.setListContent(this.mNodeList, event);
        if (aSelectedNode != null) {
            this.mApi.selectItem(this.mNodeList, aSelectedNode.getNodeAddress().getNodeId().valueToString());
        }
        this.mModel.getDialogDto().getServerContext().sendUpdate();
    }

    void mountWidgetSet200() {
        IRemoteSkinServerContext serverContext = this.mModel.getDialogDto().getServerContext();
        serverContext.mountWidgetSet(this.mModel.getWs200(), this.mModel.getDialogDto().getParentWidgetId(), "#200_Panel_Main", this::widgetSet200Mounted);
        serverContext.sendUpdate();
    }

    private void onTextChangeFilter(@NotNull CEventTextChangeNotification ev) {
        String filter = ev.getText();
        this.mModel.setFilter(filter);
        this.sendListContent(filter, null);
    }
}

