/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.index.application;

import de.sillysky.nyssr.address.CNodeId;
import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.CApplicationInstance;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.exception.CUtilCheck;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.id.common.CWellKnownNID;
import de.sillysky.nyssr.impl.network.index.application.CNetworkApplicationRegistry;
import de.sillysky.nyssr.impl.network.index.application.EAppNotification;
import de.sillysky.nyssr.message.CEnvelope;
import de.sillysky.nyssr.message.CMessage;
import de.sillysky.nyssr.namespace.IRecordHelper;
import de.sillysky.nyssr.network.broadcast.records.CRecordBroadcastSendMsg;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexAddAppInstance;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexAddAppListener;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexAppNotification;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexGetAppInstanceList;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexNotifyAvailable;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexRemoveAllListener;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexRemoveAppInstance;
import de.sillysky.nyssr.network.index.records.CRecordNetworkIndexRemoveAppListener;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.target.CTarget;
import de.sillysky.nyssr.target.ITarget;
import de.sillysky.nyssr.target.registry.ITargetRegistry;
import de.sillysky.nyssr.target.registry.records.CRecordStartTarget;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.Collection;
import java.util.UUID;

class CTargetNetworkIndex
extends CTarget {
    private IRecordHelper mRecordHelper;
    private CNetworkApplicationRegistry mRegistry;

    CTargetNetworkIndex() {
    }

    void activate(IRecordHelper aRecordHelper, CNetworkApplicationRegistry aRegistry, ITargetRegistry aTargetRegistry) throws CException {
        this.mRecordHelper = aRecordHelper;
        this.mRegistry = aRegistry;
        this.addMessageHandler(CRecordStartTarget.ID, this::asyncStartTarget);
        this.addMessageHandler(CRecordNetworkIndexAddAppInstance.ID, this::asyncAddAppInstance);
        this.addMessageHandler(CRecordNetworkIndexAddAppListener.ID, this::asyncAddAppListener);
        this.addMessageHandler(CRecordNetworkIndexGetAppInstanceList.ID, this::asyncGetAppInstanceList);
        this.addMessageHandler(CRecordNetworkIndexRemoveAppInstance.ID, this::asyncRemoveAppInstance);
        this.addMessageHandler(CRecordNetworkIndexRemoveAppListener.ID, this::asyncRemoveAppListener);
        this.addMessageHandler(CRecordNetworkIndexRemoveAllListener.ID, this::asyncRemoveAllListener);
        aTargetRegistry.registerTarget((ITarget)this);
    }

    private boolean asyncAddAppInstance(CEnvelope aEnvelope, CRecord aRecord) {
        CRecord record = CRecordNetworkIndexAddAppInstance.getAppInstance((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)record, (String)"Missing App Instance", (Object[])new Object[0]);
        CApplicationInstance instance = CApplicationInstance.create((CRecord)record);
        CUtilCheck.checkNotNull((Object)instance, (String)"Invalid Instance Data", (Object[])new Object[0]);
        this.mRegistry.addAppInstance(instance);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncAddAppListener(CEnvelope aEnvelope, CRecord aRecord) {
        CTargetAddress listener = CRecordNetworkIndexAddAppListener.getListener((CRecord)aRecord, (CTargetAddress)aEnvelope.getSender());
        UUID applicationId = CRecordNetworkIndexAddAppListener.getApplicationId((CRecord)aRecord, null);
        CStringProperties filter = CRecordNetworkIndexAddAppListener.getFilter((CRecord)aRecord, null);
        this.mRegistry.addListener(listener, applicationId, filter);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncGetAppInstanceList(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        Collection<CApplicationInstance> instances = this.mRegistry.getInstanceList();
        CRecord[] arr = new CRecord[instances.size()];
        int i = 0;
        for (CApplicationInstance inst : instances) {
            arr[i++] = inst.toRecord();
        }
        CRecordNetworkIndexGetAppInstanceList.setAppInstances((CRecord)aRecord, (CRecord[])arr);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRemoveAllListener(CEnvelope aEnvelope, CRecord aRecord) {
        CTargetAddress listener = CRecordNetworkIndexRemoveAllListener.getListener((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)listener, (String)"Missing listener", (Object[])new Object[0]);
        this.mRegistry.removeAllListener(listener);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRemoveAppInstance(CEnvelope aEnvelope, CRecord aRecord) {
        UUID instanceId = CRecordNetworkIndexRemoveAppInstance.getAppInstanceId((CRecord)aRecord, null);
        CUtilCheck.checkNotNull((Object)instanceId, (String)"Instance ID missing", (Object[])new Object[0]);
        this.mRegistry.removeAppInstance(instanceId);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncRemoveAppListener(CEnvelope aEnvelope, CRecord aRecord) {
        CTargetAddress listener = CRecordNetworkIndexRemoveAppListener.getListener((CRecord)aRecord, (CTargetAddress)aEnvelope.getSender());
        UUID applicationId = CRecordNetworkIndexRemoveAppListener.getApplicationId((CRecord)aRecord, null);
        CStringProperties filter = CRecordNetworkIndexRemoveAppListener.getFilter((CRecord)aRecord, null);
        this.mRegistry.removeListener(listener, applicationId, filter);
        aEnvelope.setResultSuccess();
        return true;
    }

    private boolean asyncStartTarget(CEnvelope aEnvelope, CRecord aRecord) throws CException {
        this.sendBroadcast(true);
        aEnvelope.setResultSuccess();
        return true;
    }

    void deactivate() {
        this.deregisterTarget();
    }

    void sendAppNotification(CTargetAddress aAddress, EAppNotification aNotification, CApplicationInstance aInstance) {
        try {
            CEnvelope env = CEnvelope.forSingleTarget((CTargetAddress)aAddress);
            CRecord record = CRecordNetworkIndexAppNotification.create();
            CRecord rec = aInstance.toRecord();
            CRecordNetworkIndexAppNotification.setAppInstance((CRecord)record, (CRecord)rec);
            CRecordNetworkIndexAppNotification.setType((CRecord)record, (String)aNotification.name());
            this.send(env, record);
        }
        catch (CException e) {
            e.printStackTrace();
        }
    }

    private void sendBroadcast(boolean aAvailable) throws CException {
        CEnvelope env1 = CEnvelope.forLocalNanoService(CRecordNetworkIndexNotifyAvailable.class);
        CRecord rec1 = CRecordNetworkIndexNotifyAvailable.create();
        CRecordNetworkIndexNotifyAvailable.setAvailable((CRecord)rec1, (boolean)aAvailable);
        CRecordNetworkIndexNotifyAvailable.setAddress((CRecord)rec1, (CTargetAddress)this.getAddress());
        CMessage msgToSend = new CMessage(env1, rec1);
        CEnvelope env2 = CEnvelope.forRemoteNanoService((IId)CWellKnownNID.SYSTEM, (CNodeId)this.getAddress().getNodeId());
        CRecord rec2 = CRecordBroadcastSendMsg.create();
        CRecordBroadcastSendMsg.setLocally((CRecord)rec2, (boolean)true);
        CRecordBroadcastSendMsg.setMessage((CRecord)rec2, (CMessage)msgToSend);
        this.sendNotification(env2, rec2);
    }
}

