/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.impl.network.index.application;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.app.CApplicationInstance;
import de.sillysky.nyssr.impl.network.index.application.CDtoListener;
import de.sillysky.nyssr.impl.network.index.application.CTargetNetworkIndex;
import de.sillysky.nyssr.impl.network.index.application.EAppNotification;
import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.properties.CStringProperties;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;
import java.util.UUID;

class CNetworkApplicationRegistry {
    private static final ILogger LOG = CLoggerFactory.getLogger(CNetworkApplicationRegistry.class);
    private final Map<UUID, CApplicationInstance> mApplicationInstanceMap = new HashMap<UUID, CApplicationInstance>();
    private final Set<CDtoListener> mListener = new HashSet<CDtoListener>();
    private CTargetNetworkIndex mTarget;

    CNetworkApplicationRegistry() {
    }

    public void activate() {
    }

    void addAppInstance(CApplicationInstance aInstance) {
        this.mApplicationInstanceMap.put(aInstance.getInstanceId(), aInstance);
        this.notifyListener(EAppNotification.ADDED, aInstance);
    }

    void addListener(CTargetAddress aAddress, UUID aApplicationID, CStringProperties aFilter) {
        CDtoListener dto = new CDtoListener(aAddress, aApplicationID, aFilter);
        this.mListener.add(dto);
        this.mApplicationInstanceMap.values().stream().filter(instance -> dto.match(instance.getApplicationId(), instance.getPresetProperties())).forEach(instance -> this.notifyListener(EAppNotification.ADDED, (CApplicationInstance)instance, dto));
    }

    Collection<CApplicationInstance> getInstanceList() {
        return new ArrayList<CApplicationInstance>(this.mApplicationInstanceMap.values());
    }

    private void notifyListener(EAppNotification aNotification, CApplicationInstance aInstance) {
        this.mListener.stream().filter(listener -> listener.match(aInstance.getApplicationId(), aInstance.getPresetProperties())).forEach(listener -> this.notifyListener(aNotification, aInstance, (CDtoListener)listener));
    }

    private void notifyListener(EAppNotification aNotification, CApplicationInstance aInstance, CDtoListener aListener) {
        this.mTarget.sendAppNotification(aListener.getListener(), aNotification, aInstance);
    }

    public void removeAllListener(CTargetAddress aListener) {
        LOG.debug("Remove all listeners for address {}", new Object[]{aListener});
        this.mListener.removeIf(listener -> aListener.equals((Object)listener.getListener()));
    }

    void removeAppInstance(UUID aInstanceId) {
        this.mApplicationInstanceMap.remove(aInstanceId);
    }

    void removeListener(CTargetAddress aAddress, UUID aApplicationId, CStringProperties aFilter) {
        this.mListener.removeIf(listener -> listener.match(aAddress, aApplicationId, aFilter));
    }

    void setTarget(CTargetNetworkIndex aTarget) {
        this.mTarget = aTarget;
    }
}

