/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.time;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CPositiveInteger;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.time.CUtilInstant;
import java.io.DataInput;
import java.io.DataOutput;
import java.io.IOException;
import java.time.Instant;
import java.util.Arrays;
import java.util.List;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CUtilInstantArray {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilInstantArray.class);

    private CUtilInstantArray() {
    }

    @Nullable
    public static @Nullable Instant @Nullable [] fromStream(@NotNull DataInput aStream) throws IOException {
        int len = CPositiveInteger.fromStream(aStream);
        if (len == 0) {
            return null;
        }
        Instant[] result = new Instant[len - 1];
        for (int i = 0; i < len - 1; ++i) {
            result[i] = CUtilInstant.fromStream(aStream);
        }
        return result;
    }

    public static void toStream(@NotNull DataOutput aStream, @Nullable Instant[] aValue) throws IOException {
        if (aValue == null) {
            CPositiveInteger.toStream(aStream, 0);
        } else {
            CPositiveInteger.toStream(aStream, aValue.length + 1);
            for (Instant aInstant : aValue) {
                CUtilInstant.toStream(aStream, aInstant);
            }
        }
    }

    @Nullable
    public static Instant[] fromString(@Nullable String aValue) {
        Instant[] result = null;
        if (CUtilString.isValid(aValue)) {
            String[] split = aValue.split(",");
            result = new Instant[split.length];
            int i = 0;
            for (String s : split) {
                result[i++] = CUtilInstant.fromString(s);
            }
        }
        return result;
    }

    @NotNull
    public static String toString(@Nullable Instant[] aValue) {
        if (aValue == null) {
            return "";
        }
        StringBuilder sb = new StringBuilder(20 * aValue.length);
        boolean first = true;
        for (Instant v : aValue) {
            if (first) {
                first = false;
            } else {
                sb.append(',');
            }
            sb.append(CUtilInstant.valueToString(v));
        }
        return sb.toString();
    }

    @NotNull
    public static Instant[] fromList(@Nullable List<?> aList) {
        Instant[] result;
        if (aList == null || aList.isEmpty()) {
            result = null;
        } else {
            result = new Instant[aList.size()];
            int i = 0;
            for (Object o : aList) {
                result[i++] = CUtilInstant.fromObject(o);
            }
        }
        return result;
    }

    public static void toStringList(@Nullable Instant[] aValue, @NotNull List<String> aList) {
        if (aValue != null && aValue.length > 0) {
            for (Instant v : aValue) {
                aList.add(CUtilInstant.valueToString(v));
            }
        }
    }

    public static boolean isEqual(@Nullable Instant[] aFirstArray, @Nullable Instant[] aSecondArray) {
        return Arrays.equals(aFirstArray, aSecondArray);
    }

    @Nullable
    public static Instant[] copy(@Nullable Instant[] aValue) {
        Instant[] result = null;
        if (aValue != null) {
            result = Arrays.copyOf(aValue, aValue.length);
        }
        return result;
    }

    @NotNull
    public static Instant[] fromObject(@Nullable Object aValue) {
        Instant[] result;
        if (aValue instanceof Instant[]) {
            result = (Instant[])aValue;
        } else if (aValue instanceof String) {
            result = CUtilInstantArray.fromString((String)aValue);
        } else if (aValue instanceof List) {
            result = CUtilInstantArray.fromList((List)aValue);
        } else if (aValue instanceof DataInput) {
            try {
                result = CUtilInstantArray.fromStream((DataInput)aValue);
            }
            catch (IOException aE) {
                LOG.error((Throwable)aE, "Error reading Instant Array from Stream.");
                result = new Instant[]{};
            }
        } else {
            result = new Instant[]{};
        }
        return result;
    }

    public static Instant[] random(int aSize) {
        Instant[] v = new Instant[aSize];
        for (int i = 0; i < aSize; ++i) {
            v[i] = CUtilInstant.random();
        }
        return v;
    }
}

