/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util.mapper;

import de.sillysky.nyssr.util.swing.CIntegerToStringMap;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public class CValueMapper {
    private static final CIntegerToStringMap mMap = new CIntegerToStringMap("ValueMapper");

    private CValueMapper() {
    }

    public static int getInt(@Nullable String aString) {
        return CValueMapper.getInt(aString, 0);
    }

    public static int getInt(@Nullable String aString, int aDefault) {
        if (aString == null) {
            return aDefault;
        }
        String s = aString.trim().toLowerCase();
        if (s.isEmpty()) {
            return aDefault;
        }
        Integer i = mMap.get(s);
        if (i == null) {
            return aDefault;
        }
        return i;
    }

    @Nullable
    public static String getString(int aInt, @Nullable String aDefault) {
        String s = mMap.get(aInt);
        if (s == null) {
            return aDefault;
        }
        return s;
    }

    @NotNull
    public static String getIntString(String aString) {
        int i = CValueMapper.getInt(aString);
        return i == 0 ? aString : Integer.toString(i);
    }

    public static void add(@NotNull String aString, int aValue) {
        mMap.add(aString, aValue);
    }

    public static void remove(@NotNull String aString) {
        mMap.remove(aString);
    }

    static {
        mMap.add("error", 0);
        mMap.add("horizontal", 1);
        mMap.add("vertical", 2);
        mMap.add("json", 3);
        mMap.add("top", 4);
        mMap.add("left", 5);
        mMap.add("right", 6);
        mMap.add("bottom", 7);
        mMap.add("all", 8);
        mMap.add("type", 9);
        mMap.add("empty", 10);
        mMap.add("line", 11);
        mMap.add("bevel", 12);
        mMap.add("lowered", 13);
        mMap.add("highlight", 14);
        mMap.add("shadow", 15);
        mMap.add("highlightinner", 16);
        mMap.add("highlightouter", 17);
        mMap.add("shadowinner", 18);
        mMap.add("shadowouter", 19);
        mMap.add("color", 20);
        mMap.add("thickness", 21);
        mMap.add("rounded", 22);
        mMap.add("none", 23);
        mMap.add("length", 24);
        mMap.add("spacing", 25);
        mMap.add("width", 26);
        mMap.add("height", 27);
        mMap.add("cap", 28);
        mMap.add("join", 29);
        mMap.add("miterlimit", 30);
        mMap.add("dash", 31);
        mMap.add("dashphase", 32);
        mMap.add("title", 33);
        mMap.add("attributes", 34);
        mMap.add("ids", 35);
        mMap.add("opaque", 36);
        mMap.add("foreground", 37);
        mMap.add("widgettype", 38);
        mMap.add("templates", 39);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
        mMap.add("-", -1);
    }
}

