/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.util;

import de.sillysky.nyssr.log.CLoggerFactory;
import de.sillysky.nyssr.log.ILogger;
import de.sillysky.nyssr.util.CUtilRandom;
import de.sillysky.nyssr.util.CUtilString;
import de.sillysky.nyssr.util.stringrecord.CStringRecord;
import org.jetbrains.annotations.Contract;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public final class CUtilShort {
    private static final ILogger LOG = CLoggerFactory.getLogger(CUtilShort.class);

    private CUtilShort() {
    }

    public static short fromObject(@Nullable Object aValue) {
        short result = 0;
        if (aValue != null) {
            if (aValue instanceof Float) {
                result = (short)((Float)aValue).floatValue();
            } else if (aValue instanceof Double) {
                result = (short)((Double)aValue).doubleValue();
            } else if (aValue instanceof Short) {
                result = (Short)aValue;
            } else if (aValue instanceof Integer) {
                result = (short)((Integer)aValue).intValue();
            } else if (aValue instanceof Long) {
                result = (short)((Long)aValue).longValue();
            } else if (aValue instanceof Byte) {
                result = ((Byte)aValue).byteValue();
            } else if (aValue instanceof Character) {
                result = (short)((Character)aValue).charValue();
            } else if (aValue instanceof String) {
                result = CUtilShort.fromString((String)aValue);
            } else {
                LOG.error("Can't convert object {} to short. Take default value '0'", aValue);
            }
        }
        return result;
    }

    public static short fromString(@Nullable String aValue) {
        short result = 0;
        if (aValue != null) {
            String value = aValue.trim();
            try {
                result = Short.parseShort(value);
            }
            catch (NumberFormatException numberFormatException) {
                // empty catch block
            }
        }
        return result;
    }

    @Contract(pure=true)
    @NotNull
    public static String toString(short aValue) {
        return Short.toString(aValue);
    }

    @NotNull
    public static String toString(short aValue, int aMaxLen) {
        String result = CUtilShort.toString(aValue);
        result = CUtilString.shortenString(result, aMaxLen);
        return result;
    }

    @NotNull
    public static String toStringRecord(short aType, short aValue) {
        String key = Short.toString(aType);
        String value = CUtilShort.toString(aValue);
        CStringRecord r = new CStringRecord(key, value);
        return r.getRecordString();
    }

    public static short random() {
        return (short)(Short.MIN_VALUE + CUtilRandom.getRandom().nextInt(65535));
    }
}

