/*
 * Decompiled with CFR 0.152.
 */
package de.sillysky.nyssr.nanoservice.records;

import de.sillysky.nyssr.address.CTargetAddress;
import de.sillysky.nyssr.exception.CException;
import de.sillysky.nyssr.id.IId;
import de.sillysky.nyssr.impl.id.CIdFactory;
import de.sillysky.nyssr.record.CRecord;
import de.sillysky.nyssr.record.IGeneratedRecord;
import de.sillysky.nyssr.slot.CCommonSlotType;
import de.sillysky.nyssr.slot.CSlotFactoryHelper;
import de.sillysky.nyssr.slot.ISlot;
import org.jetbrains.annotations.NotNull;

public final class CRecordNanoServiceRemoveObservers
implements IGeneratedRecord {
    public static final IId ID = CIdFactory.fromObject("0dbdf476-d9e3-4710-953b-954c80bbc81b");
    public static final String NAME = "NanoServiceRemoveObservers";
    public static final String DESCRIPTION = "Remove some observers from nano services.";
    public static final String SLOT_NID = "nid";
    public static final String SLOT_OBSERVER = "obs";
    public static final String SLOT_SIDS = "sids";
    public static final String[] NAMESPACES = new String[]{"SYSTEM"};
    public static final boolean IS_NANO_SERVICE = true;

    @NotNull
    public static CRecord create() {
        return new CRecord(ID);
    }

    public static IId getNid(@NotNull CRecord aRecord, IId aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_NID);
        if (slot == null) {
            return aDefault;
        }
        return (IId)slot.getValue();
    }

    public static CTargetAddress getObserver(@NotNull CRecord aRecord, CTargetAddress aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_OBSERVER);
        if (slot == null) {
            return aDefault;
        }
        return (CTargetAddress)slot.getValue();
    }

    public static IId[] getSids(@NotNull CRecord aRecord, IId[] aDefault) {
        ISlot slot = aRecord.getSlot(SLOT_SIDS);
        if (slot == null) {
            return aDefault;
        }
        return (IId[])slot.getValue();
    }

    public static void setNid(@NotNull CRecord aRecord, IId aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID, aValue);
        aRecord.addSlot(SLOT_NID, slot);
    }

    public static void setObserver(@NotNull CRecord aRecord, CTargetAddress aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.TARGET_ADDRESS, aValue);
        aRecord.addSlot(SLOT_OBSERVER, slot);
    }

    public static void setSids(@NotNull CRecord aRecord, IId[] aValue) throws CException {
        ISlot slot = CSlotFactoryHelper.fromObject(CCommonSlotType.ID_ARRAY, aValue);
        aRecord.addSlot(SLOT_SIDS, slot);
    }
}

